/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.manager;

import net.jini.core.transaction.Transaction;
import org.openspaces.core.transaction.manager.ExisitingJiniTransactionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ExistingJiniTransactionManager {
    public static final String CONTEXT = "$existingTxContext";

    public static boolean bindExistingTransaction(Transaction transaction) {
        return ExistingJiniTransactionManager.bindExistingTransaction(transaction, true, true);
    }

    public static boolean bindExistingTransaction(Transaction transaction, boolean disableCommit, boolean disableRollback) {
        if (transaction == null) {
            return false;
        }
        Transaction.Created txCreated = new Transaction.Created(transaction, null);
        ExisitingJiniTransactionHolder jiniHolder = new ExisitingJiniTransactionHolder(txCreated, -1, null);
        jiniHolder.setTimeoutInSeconds(-1);
        jiniHolder.setSynchronizedWithTransaction(true);
        jiniHolder.setDisableCommit(disableCommit);
        jiniHolder.setDisableRollback(disableRollback);
        return ExistingJiniTransactionManager.bindExistingTransaction(jiniHolder);
    }

    public static boolean bindExistingTransaction(ExisitingJiniTransactionHolder jiniHolder) {
        TransactionSynchronizationManager.bindResource((Object)CONTEXT, (Object)((Object)jiniHolder));
        return true;
    }

    public static ExisitingJiniTransactionHolder unbindExistingTransaction() {
        return (ExisitingJiniTransactionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)CONTEXT));
    }

    public static ExisitingJiniTransactionHolder unbindExistingTransactionIfPossible() {
        return (ExisitingJiniTransactionHolder)((Object)TransactionSynchronizationManager.unbindResourceIfPossible((Object)CONTEXT));
    }
}

