/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.manager;

import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.transaction.Transaction;
import net.jini.lease.LeaseRenewalManager;
import org.springframework.transaction.support.ResourceHolderSupport;

public class JiniTransactionHolder
extends ResourceHolderSupport {
    private final Transaction.Created txCreated;
    private final int isolationLevel;
    private final LeaseRenewalManager leaseRenewalManager;
    private boolean disableRollback = false;
    private boolean disableCommit = false;
    private final AtomicInteger referenceCount = new AtomicInteger();

    public JiniTransactionHolder(Transaction.Created txCreated, int isolationLevel, LeaseRenewalManager leaseRenewalManager) {
        this.txCreated = txCreated;
        this.isolationLevel = isolationLevel;
        this.leaseRenewalManager = leaseRenewalManager;
        this.referenceCount.incrementAndGet();
    }

    public int incRef() {
        return this.referenceCount.incrementAndGet();
    }

    public int decRef() {
        return this.referenceCount.decrementAndGet();
    }

    public boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setDisableRollback(boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public boolean isDisableCommit() {
        return this.disableCommit;
    }

    public void setDisableCommit(boolean disableCommit) {
        this.disableCommit = disableCommit;
    }

    public boolean hasTransaction() {
        return this.txCreated != null && this.txCreated.transaction != null;
    }

    public Transaction.Created getTxCreated() {
        return this.txCreated;
    }

    public Transaction getTransaction() {
        if (this.hasTransaction()) {
            return this.txCreated.transaction;
        }
        return null;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean hasLeaseRenewalManager() {
        return this.leaseRenewalManager != null;
    }

    public LeaseRenewalManager getLeaseRenewalManager() {
        return this.leaseRenewalManager;
    }
}

