/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.manager;

import java.util.Arrays;
import net.jini.core.transaction.server.TransactionManager;
import org.openspaces.core.jini.JiniServiceFactoryBean;
import org.openspaces.core.transaction.manager.AbstractJiniTransactionManager;
import org.openspaces.pu.service.PlainServiceDetails;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.springframework.transaction.TransactionSystemException;

public class LookupJiniTransactionManager
extends AbstractJiniTransactionManager
implements ServiceDetailsProvider {
    private static final long serialVersionUID = -917940171952237730L;
    private String transactionManagerName;
    private Long lookupTimeout;
    private String[] groups;
    private String[] locators;

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public void setLookupTimeout(Long lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public void setLocators(String[] locators) {
        this.locators = locators;
    }

    @Override
    protected TransactionManager doCreateTransactionManager() throws Exception {
        JiniServiceFactoryBean serviceFactory = new JiniServiceFactoryBean();
        serviceFactory.setServiceClass(TransactionManager.class);
        serviceFactory.setServiceName(this.transactionManagerName);
        if (this.lookupTimeout != null) {
            serviceFactory.setTimeout(this.lookupTimeout);
        }
        if (this.groups != null) {
            serviceFactory.setGroups(this.groups);
        }
        if (this.locators != null) {
            serviceFactory.setLocators(this.locators);
        }
        serviceFactory.afterPropertiesSet();
        TransactionManager transactionManager = (TransactionManager)serviceFactory.getObject();
        if (transactionManager == null) {
            String groups = "ALL";
            if (this.groups != null) {
                groups = Arrays.asList(this.groups).toString();
            }
            throw new TransactionSystemException("Failed to find Jini transaction manager using groups [" + groups + "], locators [" + Arrays.toString(this.locators) + "] timeout [" + this.lookupTimeout + "] and name [" + this.transactionManagerName + "]");
        }
        return transactionManager;
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        StringBuilder longDesc = new StringBuilder();
        longDesc.append("Lookup ");
        if (this.groups != null) {
            longDesc.append(Arrays.toString(this.groups));
        }
        if (this.locators != null) {
            longDesc.append(Arrays.toString(this.locators));
        }
        return new ServiceDetails[]{new PlainServiceDetails(this.getBeanName(), "tx-manager", "lookup", this.getBeanName(), longDesc.toString())};
    }

    @Override
    protected boolean suppportsCustomIsolationLevel() {
        return true;
    }
}

