/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.PUZipUtils;

public class FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);

    public static void deleteFileOrDirectory(File fileOrDirectory) {
        if (!com.gigaspaces.internal.io.FileUtils.deleteFileOrDirectoryIfExists((File)fileOrDirectory)) {
            throw new RuntimeException("Failed to delete " + fileOrDirectory);
        }
    }

    public static File unzipToTempFolder(File zipFile) {
        String zipFilename = zipFile.getName();
        String tempFolderPrefix = zipFilename.substring(0, zipFilename.lastIndexOf(46));
        File tempFolder = FileUtils.createTempFolder(tempFolderPrefix);
        try {
            PUZipUtils.unzip((File)zipFile, (File)tempFolder);
            return tempFolder;
        }
        catch (Exception e) {
            try {
                FileUtils.deleteFileOrDirectory(tempFolder);
            }
            catch (RuntimeException ex) {
                logger.debug((Object)("Failed to delete folder " + tempFolder), (Throwable)ex);
            }
            throw new RuntimeException("Failed to unzip file " + zipFile + " to " + tempFolder, e);
        }
    }

    public static File createTempFolder(String tempFolderPrefix) {
        File tempFile;
        try {
            tempFile = File.createTempFile("unzip_" + tempFolderPrefix.replace('.', '_'), "");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp file with prefix " + tempFolderPrefix, e);
        }
        FileUtils.deleteFileOrDirectory(tempFile);
        boolean created = tempFile.mkdirs();
        if (!created) {
            throw new RuntimeException("Failed to create temp file " + tempFile);
        }
        return tempFile;
    }

    public static byte[] unzipFileToMemory(String applicationFile, File directoryOrZip, long maxFileSizeInBytes) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(directoryOrZip);
            ZipEntry zipEntry = zipFile.getEntry(applicationFile);
            if (zipEntry == null) {
                throw new RuntimeException("Failed to load " + applicationFile + " from " + directoryOrZip);
            }
            int length = (int)zipEntry.getSize();
            if ((long)length > maxFileSizeInBytes) {
                throw new RuntimeException(applicationFile + " file size cannot be bigger than " + maxFileSizeInBytes + " bytes");
            }
            byte[] buffer = new byte[length];
            InputStream in = zipFile.getInputStream(zipEntry);
            DataInputStream din = new DataInputStream(in);
            try {
                din.readFully(buffer, 0, length);
                byte[] byArray = buffer;
                return byArray;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Failed to read application file input stream", e);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to read zip file " + directoryOrZip, e2);
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    logger.debug((Object)("Failed to close zip file " + directoryOrZip), (Throwable)e);
                }
            }
        }
    }
}

