/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

public enum MemoryUnit {
    BYTES(0),
    KILOBYTES(1),
    MEGABYTES(2),
    GIGABYTES(3),
    TERABYTES(4),
    PETABYTES(5),
    EXABYTES(6);

    private final int index;
    private static final long[] multipliers;
    private static final long[] overflows;
    private static final String[] postfixes;

    private MemoryUnit(int index) {
        this.index = index;
    }

    private static long doConvert(int delta, long memory) {
        if (delta == 0) {
            return memory;
        }
        if (delta < 0) {
            return memory / multipliers[-delta];
        }
        if (memory > overflows[delta]) {
            return Long.MAX_VALUE;
        }
        if (memory < -overflows[delta]) {
            return Long.MIN_VALUE;
        }
        return memory * multipliers[delta];
    }

    public long convert(long memory, MemoryUnit unit) {
        return MemoryUnit.doConvert(unit.index - this.index, memory);
    }

    public long toBytes(long memory) {
        return MemoryUnit.doConvert(this.index, memory);
    }

    public static long toBytes(String memory) {
        return MemoryUnit.valueOfToBytes(memory);
    }

    public long convert(String memoryCapacity) {
        return this.convert(MemoryUnit.valueOfToBytes(memoryCapacity), BYTES);
    }

    public long toKiloBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.KILOBYTES.index, memory);
    }

    public static long toKiloBytes(String memory) {
        return BYTES.toKiloBytes(MemoryUnit.toBytes(memory));
    }

    public long toMegaBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.MEGABYTES.index, memory);
    }

    public static long toMegaBytes(String memory) {
        return BYTES.toMegaBytes(MemoryUnit.toBytes(memory));
    }

    public long toGigaBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.GIGABYTES.index, memory);
    }

    public static long toGigaBytes(String memory) {
        return BYTES.toGigaBytes(MemoryUnit.toBytes(memory));
    }

    public long toTeraBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.TERABYTES.index, memory);
    }

    public static long toTeraBytes(String memory) {
        return BYTES.toTeraBytes(MemoryUnit.toBytes(memory));
    }

    public long toPetaBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.PETABYTES.index, memory);
    }

    public static long toPetaBytes(String memory) {
        return BYTES.toPetaBytes(MemoryUnit.toBytes(memory));
    }

    public long toExaBytes(long memory) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.EXABYTES.index, memory);
    }

    public static long toExaBytes(String memory) {
        return BYTES.toExaBytes(MemoryUnit.toBytes(memory));
    }

    public String toPostfix() {
        return postfixes[this.index];
    }

    private static long valueOfToBytes(String memoryCapacity) {
        int index = -1;
        if (memoryCapacity != null && memoryCapacity.length() > 1) {
            String memoryCapacityLowerCase = memoryCapacity.toLowerCase();
            String memoryUnitPostfix = memoryCapacityLowerCase.substring(memoryCapacityLowerCase.length() - 1);
            for (int i = 0; i < postfixes.length; ++i) {
                if (!postfixes[i].equals(memoryUnitPostfix)) continue;
                index = i;
                break;
            }
        }
        if (index == -1) {
            index = 0;
        } else {
            memoryCapacity = memoryCapacity.substring(0, memoryCapacity.length() - 1);
        }
        return MemoryUnit.doConvert(index, Long.valueOf(memoryCapacity));
    }

    public String getPostfix() {
        return postfixes[this.index];
    }

    static {
        multipliers = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L, 0x1000000000000000L};
        overflows = new long[]{0L, 0x1FFFFFFFFFFFFFL, 0x7FFFFFFFFFFL, 0x1FFFFFFFFL, 0x7FFFFFL, 8191L, 7L};
        postfixes = new String[]{"b", "k", "m", "g", "t", "p", "e"};
    }
}

