/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import java.util.Map;
import org.springframework.util.PropertyPlaceholderHelper;

public class PlaceholderReplacer {
    public static String replacePlaceholders(final Map<String, String> variables, final String value) throws PlaceholderResolutionException {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}");
        return helper.replacePlaceholders(value, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String key) {
                if (key.isEmpty()) {
                    throw new PlaceholderResolutionException("Placeholder in '" + value + "' has to have a length of at least 1");
                }
                String result = (String)variables.get(key);
                if (result == null) {
                    throw new PlaceholderResolutionException("Missing value for placeholder: '" + key + "' in '" + value + "'");
                }
                return result;
            }
        });
    }

    public static class PlaceholderResolutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PlaceholderResolutionException(String message) {
            super(message);
        }
    }
}

