/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.j_spaces.core.IJSpace;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;

public abstract class SpaceUtils {
    public static IJSpace getClusterMemberSpace(IJSpace space) throws DataAccessException {
        try {
            return space.getDirectProxy().getNonClusteredProxy();
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Failed to find space under name [" + space.getName() + "]", (Throwable)e);
        }
    }

    public static boolean isRemoteProtocol(IJSpace space) {
        if (space.getFinderURL() == null) {
            return false;
        }
        return space.getFinderURL().isRemoteProtocol();
    }

    public static String spaceUrlProperty(String propertyName) {
        return SpaceUrlUtils.toCustomUrlProperty((String)propertyName);
    }

    public static boolean isSameSpace(IJSpace space1, IJSpace space2) throws DataAccessException {
        ISpaceProxy space1Proxy = (ISpaceProxy)space1;
        ISpaceProxy space2Proxy = (ISpaceProxy)space2;
        if (space1Proxy.isEmbedded() != space2Proxy.isEmbedded()) {
            return false;
        }
        if (!space1Proxy.isClustered() && !space2Proxy.isClustered()) {
            return space1.equals(space2);
        }
        if (space1Proxy.isClustered() && space2Proxy.isClustered()) {
            return space1.equals(space2);
        }
        if (space1Proxy.isClustered() || space2Proxy.isClustered()) {
            return SpaceUtils.getClusterMemberSpace(space1).equals(SpaceUtils.getClusterMemberSpace(space2));
        }
        return false;
    }
}

