/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openspaces.core.util.StringPropertiesUtils;

public class StringProperties {
    Map<String, String> properties;

    public StringProperties() {
        this(new HashMap<String, String>());
    }

    public StringProperties(Properties properties) {
        this(StringPropertiesUtils.convertPropertiesToMapStringString(properties));
    }

    public StringProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public StringProperties put(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.properties.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public StringProperties putInteger(String key, int value) {
        StringPropertiesUtils.putInteger(this.properties, key, value);
        return this;
    }

    public int getInteger(String key, int defaultValue) throws NumberFormatException {
        return StringPropertiesUtils.getInteger(this.properties, key, defaultValue);
    }

    public int getIntegerIgnoreExceptions(String key, int defaultValue) {
        return StringPropertiesUtils.getIntegerIgnoreExceptions(this.properties, key, defaultValue);
    }

    public StringProperties putLong(String key, long value) {
        StringPropertiesUtils.putLong(this.properties, key, value);
        return this;
    }

    public long getLong(String key, long defaultValue) throws NumberFormatException {
        return StringPropertiesUtils.getLong(this.properties, key, defaultValue);
    }

    public long getLongIgnoreExceptions(String key, long defaultValue) {
        return StringPropertiesUtils.getLongIgnoreExceptions(this.properties, key, defaultValue);
    }

    public StringProperties putDouble(String key, double value) {
        StringPropertiesUtils.putDouble(this.properties, key, value);
        return this;
    }

    public double getDouble(String key, double defaultValue) throws NumberFormatException {
        return StringPropertiesUtils.getDouble(this.properties, key, defaultValue);
    }

    public double getDoubleIgnoreExceptions(String key, double defaultValue) {
        return StringPropertiesUtils.getDoubleIgnoreExceptions(this.properties, key, defaultValue);
    }

    public String[] getArray(String key, String separator, String[] defaultValue) {
        return StringPropertiesUtils.getArray(this.properties, key, separator, defaultValue);
    }

    public StringProperties putArray(String key, String[] value, String separator) {
        StringPropertiesUtils.putArray(this.properties, key, value, separator);
        return this;
    }

    public Set<String> getSet(String key, String separator, Set<String> defaultValue) {
        return StringPropertiesUtils.getSet(this.properties, key, separator, defaultValue);
    }

    public StringProperties putSet(String key, Set<String> value, String separator) {
        StringPropertiesUtils.putSet(this.properties, key, value, separator);
        return this;
    }

    public void store(OutputStream out, String comments) throws IOException {
        StringPropertiesUtils.store(this.properties, out, comments);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void putBoolean(String key, boolean value) {
        StringPropertiesUtils.putBoolean(this.properties, key, value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return StringPropertiesUtils.getBoolean(this.properties, key, defaultValue);
    }

    public Map<String, String> getMap(String keyPrefix, Map<String, String> defaultValue) {
        return StringPropertiesUtils.getMap(this.properties, keyPrefix, defaultValue);
    }

    public void putMap(String keyPrefix, Map<String, String> value) {
        StringPropertiesUtils.putMap(this.properties, keyPrefix, value);
    }

    public void putArgumentsArray(String key, String[] value) {
        StringPropertiesUtils.putArgumentsArray(this.properties, key, value);
    }

    public String[] getArgumentsArray(String key, String[] defaultValue) {
        return StringPropertiesUtils.getArgumentsArray(this.properties, key, defaultValue);
    }

    public void clear() {
        this.properties.clear();
    }

    public void putAll(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public void putKeyValuePairs(String key, Map<String, String> value, String pairSeperator, String keyValueSeperator) {
        StringPropertiesUtils.putKeyValuePairs(this.properties, key, value, pairSeperator, keyValueSeperator);
    }

    public Map<String, String> getKeyValuePairs(String key, String pairSeperator, String keyValueSeperator, Map<String, String> defaultValue) {
        return StringPropertiesUtils.getKeyValuePairs(this.properties, key, pairSeperator, keyValueSeperator, defaultValue);
    }

    public void putConfig(String key, Object object) {
        StringPropertiesUtils.putConfig(this.properties, key, object);
    }

    public Object getConfig(String key, Object defaultValue) {
        return StringPropertiesUtils.getConfig(this.properties, key, defaultValue);
    }

    public void putStringWrapperObject(String key, Object value) {
        StringPropertiesUtils.putStringWrapperObject(this.properties, key, value);
    }

    public Object getStringWrapperObject(String key, Object defaultValue) {
        return StringPropertiesUtils.getStringWrapperObject(this.properties, key, defaultValue);
    }

    public String toString() {
        return StringPropertiesUtils.toString(this.properties);
    }

    public boolean equals(Object other) {
        return other instanceof StringProperties && this.properties.equals(((StringProperties)other).properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

