/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import com.gigaspaces.internal.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPropertiesUtils {
    public static void store(Map<String, String> properties, OutputStream out, String comments) throws IOException {
        Properties properties2 = new Properties();
        properties2.putAll(properties);
        properties2.store(out, comments);
    }

    public static Map<String, String> load(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        return StringPropertiesUtils.convertPropertiesToMapStringString(properties);
    }

    public static Map<String, String> convertPropertiesToMapStringString(Properties properties2) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return properties;
    }

    public static Map<String, String> load(String filename) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(new File(filename));){
            Map<String, String> map = StringPropertiesUtils.load(fileInputStream);
            return map;
        }
    }

    public static int getInteger(Map<String, String> properties, String key, int defaultValue) throws NumberFormatException {
        int intValue = defaultValue;
        String value = properties.get(key);
        if (value != null) {
            intValue = Integer.valueOf(value.toString());
        }
        return intValue;
    }

    public static int getIntegerIgnoreExceptions(Map<String, String> properties, String key, int defaultValue) {
        int intValue = defaultValue;
        try {
            intValue = StringPropertiesUtils.getInteger(properties, key, defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    public static void putLong(Map<String, String> properties, String key, long value) {
        properties.put(key, String.valueOf(value));
    }

    public static long getLong(Map<String, String> properties, String key, long defaultValue) throws NumberFormatException {
        long longValue = defaultValue;
        String value = properties.get(key);
        if (value != null) {
            longValue = Long.valueOf(value.toString());
        }
        return longValue;
    }

    public static long getLongIgnoreExceptions(Map<String, String> properties, String key, long defaultValue) {
        long longValue = defaultValue;
        try {
            longValue = StringPropertiesUtils.getLong(properties, key, defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return longValue;
    }

    public static void putDouble(Map<String, String> properties, String key, double value) {
        properties.put(key, String.valueOf(value));
    }

    public static double getDouble(Map<String, String> properties, String key, double defaultValue) throws NumberFormatException {
        double doubleValue = defaultValue;
        String value = properties.get(key);
        if (value != null) {
            doubleValue = Double.valueOf(value.toString());
        }
        return doubleValue;
    }

    public static double getDoubleIgnoreExceptions(Map<String, String> properties, String key, double defaultValue) {
        double doubleValue = defaultValue;
        try {
            doubleValue = StringPropertiesUtils.getDouble(properties, key, defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return doubleValue;
    }

    public static void putArray(Map<String, String> properties, String key, String[] array, String separator) {
        if (array == null || array.length == 0) {
            properties.remove(key);
        } else {
            StringBuilder concat = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                String value = array[i];
                if (value == null || value.length() <= 0) continue;
                if (value.contains(separator)) {
                    throw new IllegalArgumentException("array contains an element '" + value + "' that contains the separator '" + separator + "'");
                }
                concat.append(value);
                if (i >= array.length - 1) continue;
                concat.append(separator);
            }
            properties.put(key, concat.toString());
        }
    }

    public static String[] getArray(Map<String, String> properties, String key, String separator, String[] defaultValue) {
        String value = properties.get(key);
        String[] array = value == null ? defaultValue : value.split(Pattern.quote(separator));
        return array;
    }

    public static Set<String> getSet(Map<String, String> properties, String key, String separator, Set<String> defaultValue) {
        String[] defaultArray = defaultValue == null ? null : defaultValue.toArray(new String[0]);
        String[] array = StringPropertiesUtils.getArray(properties, key, separator, defaultArray);
        HashSet<String> set = null;
        if (array != null) {
            set = new HashSet<String>(Arrays.asList(array));
        }
        return set;
    }

    public static void putSet(Map<String, String> properties, String key, Set<String> value, String separator) {
        if (value.isEmpty()) {
            properties.remove(key);
        } else {
            StringPropertiesUtils.putArray(properties, key, value.toArray(new String[0]), separator);
        }
    }

    public static void putArgumentsArray(Map<String, String> properties, String key, String[] array) {
        StringBuilder concat = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            String value = array[i];
            if (value == null || value.length() <= 0) continue;
            if (value.contains(" ")) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    if (value.substring(1, value.length() - 1).contains("\"")) {
                        throw new IllegalArgumentException("Argument " + value + " contains both a whitespace and a \" character.");
                    }
                } else if (value.startsWith("'") && value.endsWith("'")) {
                    if (value.substring(1, value.length() - 1).contains("'")) {
                        throw new IllegalArgumentException("Argument " + value + " contains both a whitespace and a ' character.");
                    }
                } else if (!value.contains("\"")) {
                    value = "\"" + value + "\"";
                } else if (!value.contains("'")) {
                    value = "'" + value + "'";
                } else {
                    throw new IllegalArgumentException("Argument " + value + " contains both a whitespace and \" and '");
                }
            }
            concat.append(value);
            if (i >= array.length - 1) continue;
            concat.append(' ');
        }
        properties.put(key, concat.toString());
    }

    public static String[] getArgumentsArray(Map<String, String> properties, String key, String[] defaultValue) {
        String[] array = defaultValue;
        String value = properties.get(key);
        if (value != null) {
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
            Matcher regexMatcher = regex.matcher(value);
            while (regexMatcher.find()) {
                if (regexMatcher.group(1) != null) {
                    matchList.add(regexMatcher.group(1));
                    continue;
                }
                if (regexMatcher.group(2) != null) {
                    matchList.add(regexMatcher.group(2));
                    continue;
                }
                matchList.add(regexMatcher.group());
            }
            array = matchList.toArray(new String[matchList.size()]);
        }
        return array;
    }

    public static void putInteger(Map<String, String> properties, String key, int value) {
        properties.put(key, String.valueOf(value));
    }

    public static void putBoolean(Map<String, String> properties, String key, boolean value) {
        properties.put(key, String.valueOf(value));
    }

    public static boolean getBoolean(Map<String, String> properties, String key, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        String value = properties.get(key);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                booleanValue = true;
            } else if (value.equalsIgnoreCase("false")) {
                booleanValue = false;
            } else {
                throw new IllegalArgumentException(key + " must be either true or false. The value " + key + " is illegal.");
            }
        }
        return booleanValue;
    }

    public static Map<String, String> getMap(Map<String, String> properties, String keyPrefix, Map<String, String> defaultValue) {
        Map<String, String> value = new HashMap<String, String>();
        for (Map.Entry<String, String> pair : properties.entrySet()) {
            String key = pair.getKey();
            if (!key.startsWith(keyPrefix)) continue;
            String newKey = key.substring(keyPrefix.length());
            value.put(newKey, pair.getValue());
        }
        if (value.size() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public static void putMap(Map<String, String> properties, String keyPrefix, Map<String, String> value) {
        if (properties == value) {
            throw new IllegalArgumentException("properties and value must be different objects");
        }
        HashSet<String> keysToDelete = new HashSet<String>();
        for (String string : properties.keySet()) {
            if (!string.toString().startsWith(keyPrefix)) continue;
            keysToDelete.add(string);
        }
        for (String string : keysToDelete) {
            properties.remove(string);
        }
        if (value != null) {
            for (Map.Entry entry : value.entrySet()) {
                properties.put(keyPrefix + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static String toString(Map<String, String> properties) {
        return new TreeMap<String, String>(properties).toString();
    }

    public static void putKeyValuePairs(Map<String, String> properties, String key, Map<String, String> value, String pairSeperator, String keyValueSeperator) {
        StringPropertiesUtils.putArray(properties, key, StringUtils.convertKeyValuePairsToArray(value, (String)keyValueSeperator), pairSeperator);
    }

    public static Map<String, String> getKeyValuePairs(Map<String, String> properties, String key, String pairSeperator, String keyValueSeperator, Map<String, String> defaultValue) {
        String[] pairs = StringPropertiesUtils.getArray(properties, key, pairSeperator, StringUtils.convertKeyValuePairsToArray(defaultValue, (String)keyValueSeperator));
        return StringUtils.convertArrayToKeyValuePairs((String[])pairs, (String)keyValueSeperator);
    }

    public static void putConfig(Map<String, String> properties, String key, Object object) {
        Object objectProperties;
        String classKey = key + ".class";
        String valuesKey = key + ".values.";
        if (object == null) {
            properties.remove(classKey);
            StringPropertiesUtils.putMap(properties, valuesKey, null);
            return;
        }
        Class<?> clazz = object.getClass();
        try {
            Method getPropertiesMethod = clazz.getMethod("getProperties", new Class[0]);
            objectProperties = getPropertiesMethod.invoke(object, new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to verify getProperties method", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to verify getProperties method", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to verify getProperties method", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to verify getProperties method", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to verify getProperties method", e);
        }
        if (!(properties instanceof Map)) {
            throw new IllegalArgumentException(key + " value type (" + clazz + ") does not have a getProperties() method that returns a Map");
        }
        try {
            if (clazz.getConstructor(Map.class) == null) {
                throw new IllegalArgumentException(key + " value type (" + clazz + ") does not have a constructor that accepts a String");
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to verify constructor that accepts a map", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to verify constructor that accepts a map", e);
        }
        properties.put(classKey, clazz.getName());
        StringPropertiesUtils.putMap(properties, valuesKey, (Map)objectProperties);
    }

    public static Object getConfig(Map<String, String> properties, String key, Object defaultValue) {
        Map<String, String> objectProperties;
        Object value = defaultValue;
        String className = properties.get(key + ".class");
        if (className != null && (objectProperties = StringPropertiesUtils.getMap(properties, key + ".values.", new HashMap<String, String>())) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                value = clazz.getConstructor(Map.class).newInstance(objectProperties);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
        }
        return value;
    }

    public static void putStringWrapperObject(Map<String, String> properties, String key, Object value) {
        try {
            if (value.getClass().getConstructor(String.class) == null) {
                throw new IllegalArgumentException(key + " value type (" + value.getClass() + ") does not have a constructor that accepts a String");
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to verify " + value.getClass().getName() + " class type", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to verify " + value.getClass().getName() + " class type", e);
        }
        properties.put(key + ".class", value.getClass().getName());
        properties.put(key + ".value", value.toString());
    }

    public static Object getStringWrapperObject(Map<String, String> properties, String key, Object defaultValue) {
        String valueToString;
        Object value = defaultValue;
        String className = properties.get(key + ".class");
        if (className != null && (valueToString = properties.get(key + ".value")) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                value = clazz.getConstructor(String.class).newInstance(valueToString);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to create object from properties", e);
            }
        }
        return value;
    }
}

