/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.jini.io.OptimizedByteArrayInputStream;
import net.jini.io.OptimizedByteArrayOutputStream;

public class ThreadLocalMarshaller {
    private static ThreadLocal<OptimizedByteArrayOutputStream> cachedByteArrayOutputStream = new ThreadLocal<OptimizedByteArrayOutputStream>(){

        @Override
        protected OptimizedByteArrayOutputStream initialValue() {
            return new OptimizedByteArrayOutputStream(1024);
        }
    };

    public static Object objectFromByteBuffer(byte[] buffer) throws IOException, ClassNotFoundException {
        if (buffer == null) {
            return null;
        }
        OptimizedByteArrayInputStream inStream = new OptimizedByteArrayInputStream(buffer);
        ObjectInputStream in = new ObjectInputStream((InputStream)inStream);
        Object retval = in.readObject();
        in.close();
        return retval;
    }

    public static byte[] objectToByteBuffer(Object obj) throws IOException {
        OptimizedByteArrayOutputStream outStream = cachedByteArrayOutputStream.get();
        outStream.reset();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)outStream);
        out.writeObject(obj);
        out.flush();
        byte[] result = outStream.toByteArray();
        out.close();
        return result;
    }
}

