/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util.numbers;

import java.math.BigInteger;
import org.openspaces.core.util.numbers.NumberHelper;

public class BigIntegerHelper
implements NumberHelper<BigInteger> {
    @Override
    public int compare(Number lhs, Number rhs) {
        return this.cast(lhs).compareTo(this.cast(rhs));
    }

    public boolean isGreater(BigInteger lhs, BigInteger rhs) {
        return lhs.compareTo(rhs) > 0;
    }

    @Override
    public BigInteger add(Number lhs, Number rhs) {
        BigInteger lhsBigInt = this.cast(lhs);
        BigInteger rhsBigInt = this.cast(rhs);
        return lhsBigInt.add(rhsBigInt);
    }

    @Override
    public BigInteger sub(Number lhs, Number rhs) {
        BigInteger lhsBigInt = this.cast(lhs);
        BigInteger rhsBigInt = this.cast(rhs);
        return lhsBigInt.subtract(rhsBigInt);
    }

    @Override
    public BigInteger mult(Number lhs, Number rhs) {
        BigInteger lhsBigInt = this.cast(lhs);
        BigInteger rhsBigInt = this.cast(rhs);
        return lhsBigInt.multiply(rhsBigInt);
    }

    @Override
    public BigInteger div(Number lhs, Number rhs) {
        BigInteger lhsBigInt = this.cast(lhs);
        BigInteger rhsBigInt = this.cast(rhs);
        return lhsBigInt.divide(rhsBigInt);
    }

    @Override
    public BigInteger MAX_VALUE() {
        return BigInteger.valueOf(Long.MAX_VALUE);
    }

    @Override
    public BigInteger MIN_VALUE() {
        return BigInteger.valueOf(Long.MIN_VALUE);
    }

    @Override
    public BigInteger ONE() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger ZERO() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger cast(Number n) {
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }
}

