/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.util.numbers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openspaces.core.util.numbers.BigDecimalHelper;
import org.openspaces.core.util.numbers.BigIntegerHelper;
import org.openspaces.core.util.numbers.DoubleHelper;
import org.openspaces.core.util.numbers.FloatHelper;
import org.openspaces.core.util.numbers.IntegerHelper;
import org.openspaces.core.util.numbers.LongHelper;
import org.openspaces.core.util.numbers.NumberHelper;
import org.openspaces.core.util.numbers.ShortHelper;

public class NumberHelperFactory {
    public static <N extends Number> NumberHelper<N> getNumberHelper(Class<N> type) throws IllegalArgumentException {
        if (type.equals(Integer.class)) {
            return new IntegerHelper();
        }
        if (type.equals(Long.class)) {
            return new LongHelper();
        }
        if (type.equals(Float.class)) {
            return new FloatHelper();
        }
        if (type.equals(Double.class)) {
            return new DoubleHelper();
        }
        if (type.equals(Short.class)) {
            return new ShortHelper();
        }
        if (type.equals(BigInteger.class)) {
            return new BigIntegerHelper();
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimalHelper();
        }
        throw new IllegalArgumentException("No number helper support for type [" + type.getName() + "]");
    }
}

