/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events;

import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.server.space.suspend.SuspendTypeChangedInternalListener;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.metrics.BeanMetricManager;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.server.space.suspend.SuspendType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.EntrySnapshot;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.space.mode.AfterSpaceModeChangeEvent;
import org.openspaces.core.space.mode.BeforeSpaceModeChangeEvent;
import org.openspaces.core.transaction.manager.JiniPlatformTransactionManager;
import org.openspaces.core.util.SpaceUtils;
import org.openspaces.events.DynamicEventTemplateProvider;
import org.openspaces.events.EventExceptionHandler;
import org.openspaces.events.ExceptionHandler;
import org.openspaces.events.ListenerExecutionFailedException;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.adapter.EventListenerAdapter;
import org.openspaces.events.support.AnnotationProcessorUtils;
import org.openspaces.pu.container.ProcessingUnitContainerContext;
import org.openspaces.pu.container.ProcessingUnitContainerContextAware;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractEventListenerContainer
implements ApplicationContextAware,
Lifecycle,
BeanNameAware,
InitializingBean,
DisposableBean,
ApplicationListener<ApplicationEvent>,
ServiceDetailsProvider,
ServiceMonitorsProvider,
ProcessingUnitContainerContextAware,
InternalDumpProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private GigaSpace gigaSpace;
    protected String beanName;
    private boolean activeWhenPrimary = true;
    private boolean registerSpaceModeListener = false;
    private volatile boolean active = false;
    private volatile boolean running = false;
    private final List<Object> pausedTasks = new LinkedList<Object>();
    private final Object lifecycleMonitor = new Object();
    private PrimaryBackupListener primaryBackupListener;
    private SpaceMode currentSpaceMode;
    private volatile boolean autoStart = true;
    private volatile boolean quiesced = false;
    private volatile boolean resumeAfterSuspend = false;
    private BeanMetricManager beanMetricManager;
    private SpaceDataEventListener eventListener;
    private String eventListenerRef;
    private ApplicationContext applicationContext;
    protected EventExceptionHandler exceptionHandler;
    private final LongCounter processedEvents = new LongCounter();
    private final LongCounter failedEvents = new LongCounter();
    private Object template;
    private boolean performSnapshot = true;
    private Object receiveTemplate;
    private DynamicEventTemplateProvider dynamicTemplate;
    private Object dynamicTemplateRef;
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    protected boolean disableTransactionValidation = false;
    protected ThreadLocal<EntrySnapshot> snapshotTemplateThreadLocal = new ThreadLocal();
    private SuspendTypeChangedInternalListener suspendTypeListener;

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public final GigaSpace getGigaSpace() {
        return this.gigaSpace;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    public void setActiveWhenPrimary(boolean activeWhenPrimary) {
        this.activeWhenPrimary = activeWhenPrimary;
    }

    public void setRegisterSpaceModeListener(boolean registerSpaceModeListener) {
        this.registerSpaceModeListener = registerSpaceModeListener;
    }

    public void setAutoStart(boolean initOnStartup) {
        this.autoStart = initOnStartup;
    }

    public final boolean isRunning() {
        return this.running && !this.quiesced;
    }

    public final boolean isActive() {
        return this.active;
    }

    protected String getStatus() {
        if (this.running) {
            return "started";
        }
        if (this.quiesced) {
            return "quiesced";
        }
        return "stopped";
    }

    public EventExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(EventExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setEventListener(SpaceDataEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setEventListenerRef(String eventListenerRef) {
        this.eventListenerRef = eventListenerRef;
    }

    protected SpaceDataEventListener getEventListener() {
        if (this.eventListener != null) {
            return this.eventListener;
        }
        if (this.eventListenerRef == null) {
            return null;
        }
        return (SpaceDataEventListener)this.applicationContext.getBean(this.eventListenerRef);
    }

    protected Object getActualEventListener() {
        Object listener = this.getEventListener();
        while (listener instanceof EventListenerAdapter) {
            listener = ((EventListenerAdapter)listener).getActualEventListener();
        }
        return listener;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setProcessingUnitContainerContext(ProcessingUnitContainerContext processingUnitContainerContext) {
        this.beanMetricManager = processingUnitContainerContext.createBeanMetricManager(this.getBeanName());
        if (this.running) {
            this.registerMetrics();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Class<?> getEventListenerClass() {
        if (this.eventListener != null) {
            return this.eventListener.getClass();
        }
        return this.applicationContext.getType(this.eventListenerRef);
    }

    public void afterPropertiesSet() {
        this.validateConfiguration();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws DataAccessException {
        boolean embedded;
        this.initializeTransactionManager();
        this.initializeTemplate();
        this.initializeExceptionHandler();
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = true;
            this.lifecycleMonitor.notifyAll();
        }
        this.doInitialize();
        if (!this.activeWhenPrimary) {
            this.doStart();
        }
        boolean bl = embedded = !SpaceUtils.isRemoteProtocol(this.gigaSpace.getSpace());
        if (embedded) {
            this.gigaSpace.getSpace().getDirectProxy().getSpaceImplIfEmbedded().getQuiesceHandler().addSpaceSuspendTypeListener(this.suspendTypeListener);
        }
        if (this.registerSpaceModeListener) {
            SpaceMode currentMode = SpaceMode.PRIMARY;
            if (embedded) {
                currentMode = this.registerSpaceModeListener();
            }
            SpaceInitializationIndicator.setInitializer();
            try {
                this.onApplicationEvent(new BeforeSpaceModeChangeEvent(this.gigaSpace.getSpace(), currentMode));
                this.onApplicationEvent(new AfterSpaceModeChangeEvent(this.gigaSpace.getSpace(), currentMode));
            }
            finally {
                SpaceInitializationIndicator.unsetInitializer();
            }
        }
    }

    private SpaceMode registerSpaceModeListener() {
        this.primaryBackupListener = new PrimaryBackupListener();
        try {
            IJSpace clusterMemberSpace = SpaceUtils.getClusterMemberSpace(this.gigaSpace.getSpace());
            ISpaceModeListener remoteListener = (ISpaceModeListener)clusterMemberSpace.getDirectProxy().getStubHandler().exportObject((Remote)((Object)this.primaryBackupListener));
            return ((IInternalRemoteJSpaceAdmin)clusterMemberSpace.getAdmin()).addSpaceModeListener(remoteListener);
        }
        catch (RemoteException e) {
            throw new InvalidDataAccessResourceUsageException("Failed to register space mode listener with space [" + this.gigaSpace.getSpace() + "]", (Throwable)e);
        }
    }

    protected abstract void doInitialize() throws DataAccessException;

    private void initializeTransactionManager() {
        if (this.transactionDefinition.getName() == null) {
            this.transactionDefinition.setName(this.getBeanName());
        }
    }

    protected void validateConfiguration() {
        Assert.notNull((Object)this.gigaSpace, (String)"gigaSpace property is required");
        if (this.transactionManager != null && !this.disableTransactionValidation && !this.getGigaSpace().getTxProvider().isEnabled()) {
            throw new IllegalStateException(this.message("event container is configured to run under transactions (transaction manager is provided) but GigaSpace is not transactional. Please pass the transaction manager to the GigaSpace bean as well"));
        }
    }

    private void initializeTemplate() {
        Object templateFromProvider;
        Object possibleTemplateProvider = null;
        if (this.template != null) {
            possibleTemplateProvider = this.template;
        } else {
            Class<?> eventListenerType = this.getEventListenerClass();
            if (eventListenerType != null) {
                possibleTemplateProvider = this.getActualEventListener();
            }
        }
        if (possibleTemplateProvider != null && (templateFromProvider = AnnotationProcessorUtils.findTemplateFromProvider(possibleTemplateProvider)) != null) {
            this.setTemplate(templateFromProvider);
        }
        if (this.dynamicTemplate == null && this.dynamicTemplateRef != null) {
            Object dynamicTemplateProviderBean = this.dynamicTemplateRef;
            this.dynamicTemplate = AnnotationProcessorUtils.findDynamicEventTemplateProvider(dynamicTemplateProviderBean);
            if (this.dynamicTemplate == null) {
                throw new IllegalArgumentException("Cannot find dynamic template provider in " + this.dynamicTemplateRef.getClass());
            }
        }
        if (this.template != null && this.dynamicTemplate != null) {
            throw new IllegalArgumentException("dynamicTemplate and template are mutually exclusive.");
        }
        if (this.performSnapshot && this.template != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.message("Performing snapshot on template [" + this.template + "]"));
            }
            this.receiveTemplate = this.getGigaSpace().prepareTemplate(this.template);
        } else {
            this.receiveTemplate = this.template;
        }
    }

    private void initializeExceptionHandler() {
        if (this.exceptionHandler == null && this.getActualEventListener() != null) {
            final AtomicReference ref = new AtomicReference();
            ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)this.getActualEventListener()), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (method.isAnnotationPresent(ExceptionHandler.class)) {
                        ref.set(method);
                    }
                }
            });
            if (ref.get() != null) {
                ((Method)ref.get()).setAccessible(true);
                try {
                    this.setExceptionHandler((EventExceptionHandler)((Method)ref.get()).invoke(this.getActualEventListener(), new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to set EventExceptionHandler from method [" + ((Method)ref.get()).getName() + "]", e);
                }
            }
        }
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws DataAccessException {
        boolean embedded;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.message("Shutting down Space Event listener container"));
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = false;
            this.running = false;
            this.lifecycleMonitor.notifyAll();
            this.unregisterMetrics();
        }
        boolean bl = embedded = !SpaceUtils.isRemoteProtocol(this.gigaSpace.getSpace());
        if (embedded) {
            this.gigaSpace.getSpace().getDirectProxy().getSpaceImplIfEmbedded().getQuiesceHandler().removeSpaceSuspendTypeListener(this.suspendTypeListener);
        }
        if (this.registerSpaceModeListener && embedded) {
            IJSpace clusterMemberSpace = SpaceUtils.getClusterMemberSpace(this.gigaSpace.getSpace());
            try {
                ISpaceModeListener remoteListener = (ISpaceModeListener)clusterMemberSpace.getDirectProxy().getStubHandler().exportObject((Remote)((Object)this.primaryBackupListener));
                ((IInternalRemoteJSpaceAdmin)clusterMemberSpace.getAdmin()).removeSpaceModeListener(remoteListener);
            }
            catch (RemoteException e) {
                this.logger.warn((Object)("Failed to unregister space mode listener with space [" + this.gigaSpace.getSpace() + "]"), (Throwable)e);
            }
        }
        this.doShutdown();
    }

    protected abstract void doShutdown() throws DataAccessException;

    public void start() throws DataAccessException {
        if (!this.autoStart) {
            this.autoStart = true;
        }
        if (!this.activeWhenPrimary) {
            this.doStart();
        } else if (this.currentSpaceMode != null && this.currentSpaceMode == SpaceMode.PRIMARY) {
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws DataAccessException {
        if (!this.autoStart || this.running || this.quiesced || this.getEventListener() == null) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running || this.quiesced) {
                return;
            }
            this.running = true;
            this.registerMetrics();
            this.lifecycleMonitor.notifyAll();
            Iterator<Object> it = this.pausedTasks.iterator();
            while (it.hasNext()) {
                this.doRescheduleTask(it.next());
                it.remove();
            }
        }
        this.doAfterStart();
    }

    protected void doAfterStart() throws DataAccessException {
    }

    public void stop() throws DataAccessException {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws DataAccessException {
        if (!this.running) {
            return;
        }
        this.doBeforeStop();
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.resumeAfterSuspend = false;
            this.lifecycleMonitor.notifyAll();
            this.unregisterMetrics();
        }
    }

    protected void doBeforeStop() throws DataAccessException {
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (this.activeWhenPrimary) {
            if (applicationEvent instanceof AfterSpaceModeChangeEvent) {
                AfterSpaceModeChangeEvent spEvent = (AfterSpaceModeChangeEvent)applicationEvent;
                if (spEvent.isPrimary() && SpaceUtils.isSameSpace(spEvent.getSpace(), this.gigaSpace.getSpace())) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Space [" + this.getGigaSpace() + "] became primary, starting the container"));
                    }
                    this.doStart();
                }
            } else if (applicationEvent instanceof BeforeSpaceModeChangeEvent) {
                BeforeSpaceModeChangeEvent spEvent = (BeforeSpaceModeChangeEvent)applicationEvent;
                if (!spEvent.isPrimary() && SpaceUtils.isSameSpace(spEvent.getSpace(), this.gigaSpace.getSpace())) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Space [" + this.getGigaSpace() + "] became backup, stopping the container"));
                    }
                    this.doStop();
                }
                this.currentSpaceMode = spEvent.getSpaceMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitWhileNotRunning() {
        while (this.active && !this.running) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.active && !this.running) {
                    try {
                        this.lifecycleMonitor.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean rescheduleTaskIfNecessary(Object task) {
        Assert.notNull((Object)task, (String)"Task object must not be null");
        if (this.running) {
            this.doRescheduleTask(task);
            return true;
        }
        if (this.active) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.running) {
                    this.doRescheduleTask(task);
                    return true;
                }
                this.pausedTasks.add(task);
                return true;
            }
        }
        return false;
    }

    protected void doRescheduleTask(Object task) {
        throw new UnsupportedOperationException(ClassUtils.getShortName(this.getClass()) + " does not support rescheduling of tasks");
    }

    protected void executeListener(SpaceDataEventListener eventListener, Object eventData, TransactionStatus txStatus, Object source) throws Throwable {
        if (!this.isRunning()) {
            return;
        }
        this.invokeListener(eventListener, eventData, txStatus, source);
    }

    protected void invokeListener(SpaceDataEventListener eventListener, Object eventData, TransactionStatus txStatus, Object source) throws Throwable {
        if (this.exceptionHandler != null) {
            try {
                eventListener.onEvent(eventData, this.getGigaSpace(), txStatus, source);
                this.exceptionHandler.onSuccess(eventData, this.getGigaSpace(), txStatus, source);
            }
            catch (Throwable e2) {
                ListenerExecutionFailedException e2;
                if (!(e2 instanceof ListenerExecutionFailedException)) {
                    e2 = new ListenerExecutionFailedException(e2.getMessage(), e2);
                }
                this.exceptionHandler.onException(e2, eventData, this.getGigaSpace(), txStatus, source);
            }
        } else {
            eventListener.onEvent(eventData, this.getGigaSpace(), txStatus, source);
        }
        this.processedEvents.inc();
    }

    protected void handleListenerException(Throwable ex) {
        if (ex instanceof Exception) {
            this.invokeExceptionListener((Exception)ex);
        }
        if (this.isActive()) {
            this.incrementFailedEvents();
            this.logger.error((Object)this.message("Execution of event listener failed"), ex);
        } else {
            this.logger.debug((Object)this.message("Listener exception after container shutdown"), ex);
        }
    }

    protected void invokeExceptionListener(Exception e) {
    }

    public long getProcessedEvents() {
        return this.processedEvents.getCount();
    }

    public long getFailedEvents() {
        return this.failedEvents.getCount();
    }

    protected void incrementFailedEvents() {
        this.failedEvents.inc();
    }

    public void setTemplate(Object template) {
        this.template = template;
    }

    public Object getTemplate() {
        return this.template;
    }

    public void setDynamicTemplate(Object dynamicTemplate) {
        this.dynamicTemplateRef = dynamicTemplate;
    }

    public boolean isDynamicTemplate() {
        return this.dynamicTemplate != null;
    }

    public void setPerformSnapshot(boolean performSnapshot) {
        this.performSnapshot = performSnapshot;
    }

    protected boolean isPerformSnapshot() {
        return this.performSnapshot;
    }

    public Object getReceiveTemplate() {
        if (this.dynamicTemplate != null) {
            return this.dynamicTemplate.getDynamicTemplate();
        }
        if (this.isPerformSnapshot() && this.getTransactionManager() != null) {
            EntrySnapshot entrySnapshotTemplate = this.snapshotTemplateThreadLocal.get();
            if (entrySnapshotTemplate == null) {
                ITemplatePacket cloned = ((EntrySnapshot)this.receiveTemplate).getTemplatePacket().clone();
                cloned.setOperationID(null);
                entrySnapshotTemplate = new EntrySnapshot(cloned);
                this.snapshotTemplateThreadLocal.set(entrySnapshotTemplate);
                return entrySnapshotTemplate;
            }
            return entrySnapshotTemplate;
        }
        return this.receiveTemplate;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public final PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionName(String transactionName) {
        this.transactionDefinition.setName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionDefinition.setTimeout(transactionTimeout);
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionDefinition.setIsolationLevel(transactionIsolationLevel);
    }

    public void setTransactionIsolationLevelName(String transactionIsolationLevelName) {
        this.transactionDefinition.setIsolationLevelName(transactionIsolationLevelName);
    }

    protected DefaultTransactionDefinition getTransactionDefinition() {
        return this.transactionDefinition;
    }

    public void setDisableTransactionValidation(boolean disableTransactionValidation) {
        this.disableTransactionValidation = disableTransactionValidation;
    }

    public String getTransactionManagerName() {
        if (this.transactionManager instanceof JiniPlatformTransactionManager) {
            return ((JiniPlatformTransactionManager)this.transactionManager).getBeanName();
        }
        if (this.transactionManager != null) {
            return "<<unknown>>";
        }
        return null;
    }

    public boolean isTransactional() {
        return this.transactionManager != null;
    }

    protected String message(String message) {
        return "[" + this.getBeanName() + "] " + message;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        dump.addPrefix("event-containers/");
        try {
            PrintWriter writer = new PrintWriter(dump.createFileWriter(this.beanName + ".txt"));
            this.dump(writer);
            writer.println();
            writer.close();
        }
        finally {
            dump.removePrefix();
        }
    }

    protected void dump(PrintWriter writer) {
        writer.println("===== RUNTIME =====");
        writer.println("Status: " + this.getStatus());
        writer.println("Processed events: " + this.getProcessedEvents());
        writer.println("Failed events: " + this.getFailedEvents());
        writer.println("===== CONFIGURATION =====");
        writer.println("Type                  : [" + this.getEventListenerContainerType() + "]");
        writer.println("GigaSpace             : [" + this.getGigaSpace().getName() + "]");
        writer.println("Template              : [" + this.getTemplate() + "]");
        writer.println("Transactional         : [" + this.getTransactionManagerName() + "]");
    }

    protected abstract String getEventListenerContainerType();

    protected void registerMetrics() {
        if (this.beanMetricManager != null) {
            this.beanMetricManager.register("processed-events", (Metric)this.processedEvents);
            this.beanMetricManager.register("failed-events", (Metric)this.failedEvents);
        }
    }

    protected void unregisterMetrics() {
        if (this.beanMetricManager != null) {
            this.beanMetricManager.clear();
        }
    }

    private class SuspendTypeInternalListener
    implements SuspendTypeChangedInternalListener {
        private SuspendTypeInternalListener() {
        }

        public void onSuspendTypeChanged(SuspendType suspendType) {
            AbstractEventListenerContainer.this.logger.info((Object)AbstractEventListenerContainer.this.message("SuspendType was updated to " + suspendType));
            if (suspendType != SuspendType.NONE) {
                if (AbstractEventListenerContainer.this.logger.isDebugEnabled()) {
                    AbstractEventListenerContainer.this.logger.debug((Object)(AbstractEventListenerContainer.this.message("SuspendType was updated to " + suspendType) + ", stopping..."));
                }
                boolean runningBeforeSuspend = AbstractEventListenerContainer.this.running;
                AbstractEventListenerContainer.this.stop();
                AbstractEventListenerContainer.this.resumeAfterSuspend = runningBeforeSuspend;
            } else if (AbstractEventListenerContainer.this.resumeAfterSuspend) {
                if (AbstractEventListenerContainer.this.logger.isDebugEnabled()) {
                    AbstractEventListenerContainer.this.logger.debug((Object)(AbstractEventListenerContainer.this.message("SuspendType was updated to " + suspendType) + ", starting..."));
                }
                AbstractEventListenerContainer.this.start();
            } else if (AbstractEventListenerContainer.this.logger.isDebugEnabled()) {
                AbstractEventListenerContainer.this.logger.debug((Object)(AbstractEventListenerContainer.this.message("SuspendType was updated to " + suspendType) + " but resumeAfterSuspend was set to false, not resuming..."));
            }
        }
    }

    private class PrimaryBackupListener
    implements ISpaceModeListener {
        private PrimaryBackupListener() {
        }

        public void beforeSpaceModeChange(SpaceMode spaceMode) throws RemoteException {
            AbstractEventListenerContainer.this.onApplicationEvent(new BeforeSpaceModeChangeEvent(AbstractEventListenerContainer.this.gigaSpace.getSpace(), spaceMode));
        }

        public void afterSpaceModeChange(SpaceMode spaceMode) throws RemoteException {
            AbstractEventListenerContainer.this.onApplicationEvent(new AfterSpaceModeChangeEvent(AbstractEventListenerContainer.this.gigaSpace.getSpace(), spaceMode));
        }
    }
}

