/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.adapter;

import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.events.DynamicEventTemplateProvider;
import org.openspaces.events.ListenerExecutionFailedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.util.Assert;

public abstract class AbstractReflectionDynamicEventTemplateProviderAdapter
implements InitializingBean,
DynamicEventTemplateProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private Method listenerMethod;
    private IMethod fastMethod;
    private boolean useFastRefelction = true;
    private boolean failSilentlyIfAnnotationNotFound;

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setUseFastReflection(boolean useFastReflection) {
        this.useFastRefelction = useFastReflection;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.delegate, (String)"delegate property is required");
        this.listenerMethod = this.doGetListenerMethod();
        if (this.listenerMethod != null) {
            this.fastMethod = this.useFastRefelction ? ReflectionUtil.createMethod((Method)this.listenerMethod) : new StandardMethod(this.listenerMethod);
            this.listenerMethod.setAccessible(true);
        } else if (!this.failSilentlyIfAnnotationNotFound) {
            throw new IllegalArgumentException("No event template provider method found in delegate [" + this.delegate + "]");
        }
    }

    @Override
    public Object getDynamicTemplate() {
        Object result = null;
        try {
            result = this.fastMethod.invoke(this.delegate, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new PermissionDeniedDataAccessException("Failed to invoke event method [" + this.listenerMethod.getName() + "]", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new ListenerExecutionFailedException("Listener event method [" + this.listenerMethod.getName() + "] of class [" + this.listenerMethod.getDeclaringClass().getName() + "] threw exception", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ListenerExecutionFailedException("Listener event method [" + this.listenerMethod.getName() + "] of class [" + this.listenerMethod.getDeclaringClass().getName() + "] threw exception", ex);
        }
        return result;
    }

    public void setFailSilentlyIfMethodNotFound(boolean failSilently) {
        this.failSilentlyIfAnnotationNotFound = failSilently;
    }

    public boolean isMethodFound() {
        return this.fastMethod != null;
    }

    protected abstract Method doGetListenerMethod();
}

