/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.adapter;

import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.ListenerExecutionFailedException;
import org.openspaces.events.adapter.AbstractResultEventListenerAdapter;
import org.openspaces.events.adapter.EventListenerAdapter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;

public abstract class AbstractReflectionEventListenerAdapter
extends AbstractResultEventListenerAdapter
implements InitializingBean,
EventListenerAdapter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private Method[] listenerMethods;
    private IMethod fastMethod;
    private int numberOfParameters;
    private boolean useFastReflection = true;

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setUseFastReflection(boolean useFastReflection) {
        this.useFastReflection = useFastReflection;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.delegate, (String)"delegate property is required");
        this.listenerMethods = this.doGetListenerMethods();
        if (this.listenerMethods == null || this.listenerMethods.length == 0) {
            throw new IllegalArgumentException("No event listening methods found in delegate [" + this.delegate + "]");
        }
        if (this.listenerMethods.length > 1) {
            String methodName = this.listenerMethods[0].getName();
            for (int i = 1; i < this.listenerMethods.length; ++i) {
                if (methodName.equals(this.listenerMethods[i].getName())) continue;
                throw new IllegalArgumentException("All listener methods must have the same name. Found [" + methodName + "] and [" + this.listenerMethods[i].getName() + "]");
            }
            int numbersOfParams = this.listenerMethods[0].getParameterTypes().length;
            for (int i = 1; i < this.listenerMethods.length; ++i) {
                if (numbersOfParams == this.listenerMethods[i].getParameterTypes().length) continue;
                throw new IllegalArgumentException("All listener methods must have number of parameters. Found [" + numbersOfParams + "] and [" + this.listenerMethods[i].getParameterTypes().length + "]");
            }
        } else {
            this.fastMethod = this.useFastReflection ? ReflectionUtil.createMethod((Method)this.listenerMethods[0]) : new StandardMethod(this.listenerMethods[0]);
        }
        for (Method listenerMethod : this.listenerMethods) {
            listenerMethod.setAccessible(true);
        }
        this.numberOfParameters = this.listenerMethods[0].getParameterTypes().length;
    }

    @Override
    protected Object onEventWithResult(Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) {
        Method listenerMethod = this.listenerMethods[0];
        Object[] listenerArguments = null;
        if (this.numberOfParameters == 1) {
            listenerArguments = new Object[]{data};
        } else if (this.numberOfParameters == 2) {
            listenerArguments = new Object[]{data, gigaSpace};
        } else if (this.numberOfParameters == 3) {
            listenerArguments = new Object[]{data, gigaSpace, txStatus};
        } else if (this.numberOfParameters == 4) {
            listenerArguments = new Object[]{data, gigaSpace, txStatus, source};
        }
        Object result = null;
        if (this.listenerMethods.length == 1) {
            try {
                result = this.fastMethod.invoke(this.delegate, listenerArguments);
            }
            catch (IllegalAccessException ex) {
                throw new PermissionDeniedDataAccessException("Failed to invoke event method [" + listenerMethod.getName() + "]", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new ListenerExecutionFailedException("Listener event method [" + listenerMethod.getName() + "] of class [" + listenerMethod.getDeclaringClass().getName() + "] threw exception", ex.getTargetException());
            }
            catch (Throwable ex) {
                throw new ListenerExecutionFailedException("Listener event method [" + listenerMethod.getName() + "] of class [" + listenerMethod.getDeclaringClass().getName() + "] threw exception", ex);
            }
        }
        MethodInvoker methodInvoker = new MethodInvoker();
        methodInvoker.setTargetObject(this.getDelegate());
        methodInvoker.setTargetMethod(listenerMethod.getName());
        methodInvoker.setArguments(listenerArguments);
        try {
            methodInvoker.prepare();
            result = methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            throw new ListenerExecutionFailedException("Listener method '" + listenerMethod.getName() + "' threw exception", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + listenerMethod.getName() + "' with arguments " + ObjectUtils.nullSafeToString((Object[])listenerArguments), ex);
        }
        return result;
    }

    @Override
    public Object getActualEventListener() {
        return this.delegate;
    }

    protected abstract Method[] doGetListenerMethods();
}

