/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.adapter;

import com.gigaspaces.client.WriteModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.SpaceDataEventListener;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionStatus;

public abstract class AbstractResultEventListenerAdapter
implements SpaceDataEventListener {
    private long writeLease = Long.MAX_VALUE;
    private boolean updateOrWrite = true;
    private long updateTimeout = 0L;

    public void setWriteLease(long writeLease) {
        this.writeLease = writeLease;
    }

    public void setUpdateOrWrite(boolean updateOrWrite) {
        this.updateOrWrite = updateOrWrite;
    }

    public void setUpdateTimeout(long updateTimeout) {
        this.updateTimeout = updateTimeout;
    }

    public void onEvent(Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) {
        Object result = this.onEventWithResult(data, gigaSpace, txStatus, source);
        this.handleResult(result, gigaSpace);
    }

    protected void handleResult(Object result, GigaSpace gigaSpace) throws DataAccessException {
        if (result != null) {
            if (result instanceof Object[]) {
                Object[] resultArr = (Object[])result;
                if (this.updateOrWrite) {
                    gigaSpace.writeMultiple(resultArr, this.writeLease, WriteModifiers.UPDATE_OR_WRITE);
                } else {
                    gigaSpace.writeMultiple(resultArr, this.writeLease, WriteModifiers.WRITE_ONLY);
                }
            } else if (this.updateOrWrite) {
                gigaSpace.write(result, this.writeLease, this.updateTimeout, WriteModifiers.UPDATE_OR_WRITE);
            } else {
                gigaSpace.write(result, this.writeLease, this.updateTimeout, WriteModifiers.WRITE_ONLY);
            }
        }
    }

    protected abstract Object onEventWithResult(Object var1, GigaSpace var2, TransactionStatus var3, Object var4);
}

