/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.adapter.EventListenerAdapter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;

public class TaskExecutorEventListenerAdapter
implements SpaceDataEventListener,
InitializingBean,
EventListenerAdapter {
    private static Log logger = LogFactory.getLog(TaskExecutorEventListenerAdapter.class);
    private TaskExecutor taskExecutor;
    private SpaceDataEventListener delegate;

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDelegate(SpaceDataEventListener delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"delegate SpaceDataEventListener must not be null");
        if (this.taskExecutor == null) {
            SimpleAsyncTaskExecutor simpleAsyncTaskExecutor = new SimpleAsyncTaskExecutor();
            simpleAsyncTaskExecutor.setDaemon(true);
            this.taskExecutor = simpleAsyncTaskExecutor;
        }
    }

    @Override
    public Object getActualEventListener() {
        return this.delegate;
    }

    public void onEvent(final Object data, final GigaSpace gigaSpace, final TransactionStatus txStatus, final Object source) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskExecutorEventListenerAdapter.this.delegate.onEvent(data, gigaSpace, txStatus, source);
                }
                catch (Exception e) {
                    logger.warn((Object)"Delegate threw an exception within a separate thread, ignoring...", (Throwable)e);
                }
            }
        });
    }
}

