/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.asyncpolling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.events.EventContainerServiceDetails;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceDetails;
import org.openspaces.pu.service.PlainAggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class AggregatedAsyncPollingEventContainerServiceDetails
extends PlainAggregatedServiceDetails {
    private static final long serialVersionUID = 6886365711202765516L;

    public AggregatedAsyncPollingEventContainerServiceDetails() {
    }

    public AggregatedAsyncPollingEventContainerServiceDetails(String serviceType, ServiceDetails[] details) {
        super(serviceType, details);
        int concurrentConsumers = 0;
        for (ServiceDetails detail : details) {
            if (!(detail instanceof AsyncPollingEventContainerServiceDetails)) {
                throw new IllegalArgumentException("Details [" + detail.getClass().getName() + "] is of wrong type");
            }
            AsyncPollingEventContainerServiceDetails asyncPOllingServiceDetails = (AsyncPollingEventContainerServiceDetails)detail;
            concurrentConsumers += asyncPOllingServiceDetails.getConcurrentConsumers().intValue();
        }
        this.getAttributes().put("concurrent-consumers", concurrentConsumers);
    }

    public long getReceiveTimeout() {
        return (Long)this.getAttributes().get("receive-timeout");
    }

    public int getConcurrentConsumers() {
        return (Integer)this.getAttributes().get("concurrent-consumers");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes
    extends EventContainerServiceDetails.Attributes {
        public static final String RECEIVE_TIMEOUT = "receive-timeout";
        public static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
    }
}

