/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.asyncpolling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.events.EventContainerServiceDetails;
import org.openspaces.events.asyncpolling.AggregatedAsyncPollingEventContainerServiceDetails;
import org.openspaces.pu.service.AggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class AsyncPollingEventContainerServiceDetails
extends EventContainerServiceDetails {
    private static final long serialVersionUID = -2888577681327987480L;
    public static final String SERVICE_SUB_TYPE = "async-polling";

    public AsyncPollingEventContainerServiceDetails() {
    }

    public AsyncPollingEventContainerServiceDetails(String id, String gigaSpace, Object template, boolean performSnapshot, String transactionManager, long receiveTimeout, int concurrentConsumers) {
        super(id, SERVICE_SUB_TYPE, gigaSpace, "Async Polling event container", "Async Polling event container, template [" + template + "]", template, performSnapshot, transactionManager);
        this.getAttributes().put("receive-timeout", receiveTimeout);
        this.getAttributes().put("concurrent-consumers", concurrentConsumers);
    }

    public Long getReceiveTimeout() {
        return (Long)this.getAttributes().get("receive-timeout");
    }

    public Integer getConcurrentConsumers() {
        return (Integer)this.getAttributes().get("concurrent-consumers");
    }

    @Override
    public AggregatedServiceDetails aggregateByServiceSubType(ServiceDetails[] servicesDetails) {
        return new AggregatedAsyncPollingEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public AggregatedServiceDetails aggregateById(ServiceDetails[] servicesDetails) {
        return new AggregatedAsyncPollingEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes
    extends EventContainerServiceDetails.Attributes {
        public static final String RECEIVE_TIMEOUT = "receive-timeout";
        public static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
    }
}

