/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.asyncpolling;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.core.transaction.internal.TransactionalAsyncFutureListener;
import org.openspaces.events.AbstractEventListenerContainer;
import org.openspaces.events.ListenerExecutionFailedException;
import org.openspaces.events.asyncpolling.AsyncHandler;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceDetails;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceMonitors;
import org.openspaces.events.asyncpolling.receive.AsyncOperationHandler;
import org.openspaces.events.asyncpolling.receive.SingleTakeAsyncOperationHandler;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.springframework.aop.support.AopUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SimpleAsyncPollingEventListenerContainer
extends AbstractEventListenerContainer {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 60000L;
    private long receiveTimeout = 60000L;
    private AsyncOperationHandler asyncOperationHandler;
    private int concurrentConsumers = 1;
    private AsyncFutureListener listener = new AsyncEventListener();

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    protected long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setAsyncOperationHandler(AsyncOperationHandler asyncOperationHandler) {
        this.asyncOperationHandler = asyncOperationHandler;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        Object tempalte = this.getTemplate();
        if (!(tempalte instanceof Serializable)) {
            tempalte = null;
        }
        return new ServiceDetails[]{new AsyncPollingEventContainerServiceDetails(this.beanName, this.getGigaSpace().getName(), tempalte, this.isPerformSnapshot(), this.getTransactionManagerName(), this.receiveTimeout, this.concurrentConsumers)};
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new AsyncPollingEventContainerServiceMonitors(this.beanName, this.getProcessedEvents(), this.getFailedEvents(), this.getStatus())};
    }

    public String getName() {
        return this.beanName;
    }

    @Override
    protected String getEventListenerContainerType() {
        return "Async Polling Container";
    }

    @Override
    protected void dump(PrintWriter writer) {
        super.dump(writer);
        writer.println("Receive Timeout       : [" + this.getReceiveTimeout() + "]");
        writer.println("Consumers             : [" + this.concurrentConsumers + "]");
    }

    @Override
    public void initialize() throws DataAccessException {
        if (this.asyncOperationHandler == null) {
            if (this.getActualEventListener() != null) {
                final AtomicReference ref = new AtomicReference();
                ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)this.getActualEventListener()), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                        if (method.isAnnotationPresent(AsyncHandler.class)) {
                            ref.set(method);
                        }
                    }
                });
                if (ref.get() != null) {
                    ((Method)ref.get()).setAccessible(true);
                    try {
                        this.setAsyncOperationHandler((AsyncOperationHandler)((Method)ref.get()).invoke(this.getActualEventListener(), new Object[0]));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to set AsyncOperationHandler from method [" + ((Method)ref.get()).getName() + "]", e);
                    }
                }
            }
            if (this.asyncOperationHandler == null) {
                this.asyncOperationHandler = new SingleTakeAsyncOperationHandler();
            }
        }
        super.initialize();
        this.getTransactionDefinition().setPropagationBehavior(3);
    }

    @Override
    protected void doInitialize() throws DataAccessException {
    }

    @Override
    protected void doShutdown() throws DataAccessException {
    }

    @Override
    protected void doAfterStart() throws DataAccessException {
        super.doAfterStart();
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.reschedule(this.listener);
        }
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.getBeanName()).append("] ").append("Started");
            if (this.getTransactionManager() != null) {
                sb.append(" transactional");
            }
            sb.append(" async polling event container");
            if (this.getTemplate() != null) {
                sb.append(", template ").append(ClassUtils.getShortName(this.getTemplate().getClass())).append("[").append(this.getTemplate()).append("]");
            } else {
                sb.append(", template [null]");
            }
            this.logger.debug((Object)sb.toString());
        }
    }

    private void reschedule(AsyncFutureListener listener) {
        if (!this.isRunning()) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.message("Rescheduling async receive operation"));
        }
        if (this.getTransactionManager() != null) {
            TransactionStatus status = this.getTransactionManager().getTransaction((TransactionDefinition)this.getTransactionDefinition());
            try {
                this.asyncOperationHandler.asyncReceive(this.getReceiveTemplate(), this.getGigaSpace(), this.receiveTimeout, listener);
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            if (!status.isCompleted()) {
                this.getTransactionManager().commit(status);
            }
        } else {
            this.asyncOperationHandler.asyncReceive(this.getReceiveTemplate(), this.getGigaSpace(), this.receiveTimeout, listener);
        }
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.trace((Object)this.message("Initiating transaction rollback on application exception"), ex);
        try {
            this.getTransactionManager().rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)this.message("Application exception overridden by rollback exception"), ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)this.message("Application exception overridden by rollback error"), ex);
            throw err;
        }
    }

    private class AsyncEventListener
    implements TransactionalAsyncFutureListener {
        private AsyncEventListener() {
        }

        public void onTransactionalResult(AsyncResult asyncResult, TransactionStatus txStatus) {
            if (asyncResult.getException() != null) {
                if (SimpleAsyncPollingEventListenerContainer.this.logger.isWarnEnabled()) {
                    SimpleAsyncPollingEventListenerContainer.this.logger.warn((Object)SimpleAsyncPollingEventListenerContainer.this.message("Async result operation internal exception"), (Throwable)asyncResult.getException());
                }
            } else if (asyncResult.getResult() != null) {
                try {
                    SimpleAsyncPollingEventListenerContainer.this.executeListener(SimpleAsyncPollingEventListenerContainer.this.getEventListener(), asyncResult.getResult(), null, asyncResult);
                }
                catch (Throwable e) {
                    SimpleAsyncPollingEventListenerContainer.this.handleListenerException(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ListenerExecutionFailedException(e.getMessage(), e);
                }
            }
        }

        public void onPostCommitTransaction(AsyncResult asyncResult) {
            SimpleAsyncPollingEventListenerContainer.this.reschedule(this);
        }

        public void onPostRollbackTransaction(AsyncResult asyncResult) {
            SimpleAsyncPollingEventListenerContainer.this.reschedule(this);
        }

        public void onResult(AsyncResult asyncResult) {
        }
    }
}

