/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractEventContainerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String LISTENER = "listener";
    private static final String GIGA_SPACE = "giga-space";
    private static final String ACTIVE_WHEN_PRIMARY = "active-when-primary";
    private static final String AUTO_START = "auto-start";
    private static final String EXCEPTION_HANDLER = "exception-handler";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String autoStart;
        Element exceptionHandlerEle;
        super.doParse(element, parserContext, builder);
        Element listenerEle = DomUtils.getChildElementByTagName((Element)element, (String)LISTENER);
        if (listenerEle != null) {
            String listenerRef = listenerEle.getAttribute("ref");
            if (StringUtils.hasLength((String)listenerRef)) {
                builder.addPropertyValue("eventListenerRef", (Object)listenerRef);
            } else {
                builder.addPropertyValue("eventListener", parserContext.getDelegate().parsePropertyValue(listenerEle, (BeanDefinition)builder.getRawBeanDefinition(), "eventListener"));
            }
        }
        if ((exceptionHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)EXCEPTION_HANDLER)) != null) {
            builder.addPropertyValue("exceptionHandler", parserContext.getDelegate().parsePropertyValue(exceptionHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "exceptionHandler"));
        }
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        builder.addPropertyReference("gigaSpace", gigaSpace);
        String activeWhenPrimary = element.getAttribute(ACTIVE_WHEN_PRIMARY);
        if (StringUtils.hasLength((String)activeWhenPrimary)) {
            builder.addPropertyValue("activeWhenPrimary", (Object)Boolean.valueOf(activeWhenPrimary));
        }
        if (StringUtils.hasLength((String)(autoStart = element.getAttribute(AUTO_START)))) {
            builder.addPropertyValue("autoStart", (Object)Boolean.valueOf(autoStart));
        }
    }
}

