/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.config;

import org.openspaces.events.config.AbstractTxEventContainerBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AbstractTemplateEventContainerBeanDefinitionParser
extends AbstractTxEventContainerBeanDefinitionParser {
    private static final String TEMPLATE = "template";
    private static final String SQL_QUERY = "sql-query";
    private static final String DYNAMIC_TEMPLATE = "dynamic-template";

    protected boolean isSupportsDynamicTemplate() {
        return true;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        Element dynamicTemplateEle = DomUtils.getChildElementByTagName((Element)element, (String)DYNAMIC_TEMPLATE);
        if (this.isSupportsDynamicTemplate() && dynamicTemplateEle != null) {
            builder.addPropertyValue("dynamicTemplate", parserContext.getDelegate().parsePropertyValue(dynamicTemplateEle, (BeanDefinition)builder.getRawBeanDefinition(), "dynamicTemplate"));
        } else {
            Element sqlQueryEle;
            Element templateEle = DomUtils.getChildElementByTagName((Element)element, (String)TEMPLATE);
            if (templateEle != null) {
                Object template = parserContext.getDelegate().parsePropertyValue(templateEle, (BeanDefinition)builder.getRawBeanDefinition(), TEMPLATE);
                builder.addPropertyValue(TEMPLATE, template);
            }
            if ((sqlQueryEle = DomUtils.getChildElementByTagName((Element)element, (String)SQL_QUERY)) != null) {
                builder.addPropertyValue(TEMPLATE, parserContext.getDelegate().parsePropertySubElement(sqlQueryEle, (BeanDefinition)builder.getRawBeanDefinition(), null));
            }
        }
    }
}

