/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.config;

import org.openspaces.events.config.AbstractEventContainerBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractTxEventContainerBeanDefinitionParser
extends AbstractEventContainerBeanDefinitionParser {
    private static final String TX_MANAGER = "tx-manager";
    private static final String TX_NAME = "tx-name";
    private static final String TX_TIMEOUT = "tx-timeout";
    private static final String TX_ISOLATION = "tx-isolation";

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        Element txElement = DomUtils.getChildElementByTagName((Element)element, (String)"tx-support");
        if (txElement != null) {
            String txIsolation;
            String txTimeout;
            String txName;
            String txManager = txElement.getAttribute(TX_MANAGER);
            if (StringUtils.hasLength((String)txManager)) {
                builder.addPropertyReference("transactionManager", txManager);
            }
            if (StringUtils.hasLength((String)(txName = txElement.getAttribute(TX_NAME)))) {
                builder.addPropertyValue("transactionName", (Object)txName);
            }
            if (StringUtils.hasLength((String)(txTimeout = txElement.getAttribute(TX_TIMEOUT)))) {
                builder.addPropertyValue("transactionTimeout", (Object)txTimeout);
            }
            if (StringUtils.hasLength((String)(txIsolation = txElement.getAttribute(TX_ISOLATION)))) {
                builder.addPropertyValue("transactionIsolationLevelName", (Object)("ISOLATION_" + txIsolation));
            }
        }
    }
}

