/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.config;

import org.openspaces.events.asyncpolling.SimpleAsyncPollingEventListenerContainer;
import org.openspaces.events.config.AbstractTemplateEventContainerBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AsyncPollingContainerBeanDefinitionParser
extends AbstractTemplateEventContainerBeanDefinitionParser {
    private static final String ASYNC_OPERATION_HANDLER = "async-operation-handler";
    private static final String RECEIVE_TIMEOUT = "receive-timeout";
    private static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
    private static final String PERFORM_SNAPSHOT = "perform-snapshot";

    protected Class<SimpleAsyncPollingEventListenerContainer> getBeanClass(Element element) {
        return SimpleAsyncPollingEventListenerContainer.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String performSnapshot;
        String concurrentConsumers;
        String receiveTimeout;
        super.doParse(element, parserContext, builder);
        Element asyncOperationHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)ASYNC_OPERATION_HANDLER);
        if (asyncOperationHandlerEle != null) {
            builder.addPropertyValue("asyncOperationHandler", parserContext.getDelegate().parsePropertyValue(asyncOperationHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "asyncOperationHandler"));
        }
        if (StringUtils.hasLength((String)(receiveTimeout = element.getAttribute(RECEIVE_TIMEOUT)))) {
            builder.addPropertyValue("receiveTimeout", (Object)receiveTimeout);
        }
        if (StringUtils.hasLength((String)(concurrentConsumers = element.getAttribute(CONCURRENT_CONSUMERS)))) {
            builder.addPropertyValue("concurrentConsumers", (Object)concurrentConsumers);
        }
        if (StringUtils.hasLength((String)(performSnapshot = element.getAttribute(PERFORM_SNAPSHOT)))) {
            builder.addPropertyValue("performSnapshot", (Object)performSnapshot);
        }
    }
}

