/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.config;

import org.openspaces.events.config.AbstractTemplateEventContainerBeanDefinitionParser;
import org.openspaces.events.polling.SimplePollingEventListenerContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PollingContainerBeanDefinitionParser
extends AbstractTemplateEventContainerBeanDefinitionParser {
    private static final String RECEIVE_OPERATION_HANDLER = "receive-operation-handler";
    private static final String TRIGGER_OPERATION_HANDLER = "trigger-operation-handler";
    private static final String RECEIVE_TIMEOUT = "receive-timeout";
    private static final String RECOVERY_INTERVAL = "recovery-interval";
    private static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
    private static final String MAX_CONCURRENT_CONSUMERS = "max-concurrent-consumers";
    private static final String IDLE_TASK_EXECUTION_LIMIT = "idle-task-execution-limit";
    private static final String PERFORM_SNAPSHOT = "perform-snapshot";
    private static final String PASS_ARRAY_AS_IS = "pass-array-as-is";
    private static final String KEEP_ALIVE_RETRIES = "keep-alive-retries";

    protected Class<SimplePollingEventListenerContainer> getBeanClass(Element element) {
        return SimplePollingEventListenerContainer.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String keepAliveRetries;
        String passArrayAsIs;
        String performSnapshot;
        String idleTaskExecutionLimit;
        String maxConcurrentConsumers;
        String concurrentConsumers;
        String recoveryInterval;
        String receiveTimeout;
        Element triggerOperationHandlerEle;
        super.doParse(element, parserContext, builder);
        Element receiveOperationHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)RECEIVE_OPERATION_HANDLER);
        if (receiveOperationHandlerEle != null) {
            builder.addPropertyValue("receiveOperationHandler", parserContext.getDelegate().parsePropertyValue(receiveOperationHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "receiveOperationHandler"));
        }
        if ((triggerOperationHandlerEle = DomUtils.getChildElementByTagName((Element)element, (String)TRIGGER_OPERATION_HANDLER)) != null) {
            builder.addPropertyValue("triggerOperationHandler", parserContext.getDelegate().parsePropertyValue(triggerOperationHandlerEle, (BeanDefinition)builder.getRawBeanDefinition(), "triggerOperationHandler"));
        }
        if (StringUtils.hasLength((String)(receiveTimeout = element.getAttribute(RECEIVE_TIMEOUT)))) {
            builder.addPropertyValue("receiveTimeout", (Object)receiveTimeout);
        }
        if (StringUtils.hasLength((String)(recoveryInterval = element.getAttribute(RECOVERY_INTERVAL)))) {
            builder.addPropertyValue("recoveryInterval", (Object)recoveryInterval);
        }
        if (StringUtils.hasLength((String)(concurrentConsumers = element.getAttribute(CONCURRENT_CONSUMERS)))) {
            builder.addPropertyValue("concurrentConsumers", (Object)concurrentConsumers);
        }
        if (StringUtils.hasLength((String)(maxConcurrentConsumers = element.getAttribute(MAX_CONCURRENT_CONSUMERS)))) {
            builder.addPropertyValue("maxConcurrentConsumers", (Object)maxConcurrentConsumers);
        }
        if (StringUtils.hasLength((String)(idleTaskExecutionLimit = element.getAttribute(IDLE_TASK_EXECUTION_LIMIT)))) {
            builder.addPropertyValue("idleTaskExecutionLimit", (Object)idleTaskExecutionLimit);
        }
        if (StringUtils.hasLength((String)(performSnapshot = element.getAttribute(PERFORM_SNAPSHOT)))) {
            builder.addPropertyValue("performSnapshot", (Object)performSnapshot);
        }
        if (StringUtils.hasLength((String)(passArrayAsIs = element.getAttribute(PASS_ARRAY_AS_IS)))) {
            builder.addPropertyValue("passArrayAsIs", (Object)passArrayAsIs);
        }
        if (StringUtils.hasLength((String)(keepAliveRetries = element.getAttribute(KEEP_ALIVE_RETRIES)))) {
            builder.addPropertyValue("keepAliveRetries", (Object)keepAliveRetries);
        }
    }
}

