/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.notify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.events.EventContainerServiceDetails;
import org.openspaces.events.notify.AggregatedNotifyEventContainerServiceDetails;
import org.openspaces.pu.service.AggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class NotifyEventContainerServiceDetails
extends EventContainerServiceDetails {
    private static final long serialVersionUID = -3767022008839525953L;
    public static final String SERVICE_SUB_TYPE = "notify";

    public NotifyEventContainerServiceDetails() {
    }

    public NotifyEventContainerServiceDetails(String id, String gigaSpace, Object template, boolean performSnapshot, String transactionManager, int commType, boolean fifo, Integer batchSize, Integer batchTime, Integer batchPendingThreshold, boolean autoRenew, Boolean notifyAll, Boolean notifyWrite, Boolean notifyUpdate, Boolean notifyTake, Boolean notifyLeaseExpire, Boolean notifyUnmatched, Boolean notifyMatched, Boolean notifyRematched, Boolean triggerNotifyTemplate, Boolean replicateNotifyTemplate, boolean performTakeOnNotify, boolean passArrayAsIs, boolean guaranteed, boolean durable) {
        super(id, SERVICE_SUB_TYPE, gigaSpace, "Notify event container", "Notify event container, template [" + template + "]", template, performSnapshot, transactionManager);
        switch (commType) {
            case 0: {
                this.getAttributes().put("comm-type", "unicast");
                break;
            }
            case 1: {
                this.getAttributes().put("comm-type", "multiplex");
                break;
            }
            case 2: {
                this.getAttributes().put("comm-type", "multicast");
            }
        }
        this.getAttributes().put("fifo", fifo);
        this.getAttributes().put("batch-size", batchSize);
        this.getAttributes().put("batch-time", batchTime);
        this.getAttributes().put("batch-pending-threshold", batchPendingThreshold);
        this.getAttributes().put("auto-renew", autoRenew);
        if (notifyAll != null && notifyAll.booleanValue()) {
            this.getAttributes().put("notify-write", Boolean.TRUE);
            this.getAttributes().put("notify-update", Boolean.TRUE);
            this.getAttributes().put("notify-take", Boolean.TRUE);
            this.getAttributes().put("notify-lease-expire", Boolean.TRUE);
        } else {
            this.getAttributes().put("notify-write", notifyWrite == null ? Boolean.FALSE : notifyWrite);
            this.getAttributes().put("notify-update", notifyUpdate == null ? Boolean.FALSE : notifyUpdate);
            this.getAttributes().put("notify-take", notifyTake == null ? Boolean.FALSE : notifyTake);
            this.getAttributes().put("notify-lease-expire", notifyLeaseExpire == null ? Boolean.FALSE : notifyLeaseExpire);
            this.getAttributes().put("notify-unmatched", notifyUnmatched == null ? Boolean.FALSE : notifyUnmatched);
            this.getAttributes().put("notify-matched", notifyMatched == null ? Boolean.FALSE : notifyMatched);
            this.getAttributes().put("notify-rematched", notifyRematched == null ? Boolean.FALSE : notifyRematched);
        }
        this.getAttributes().put("trigger-notify-template", triggerNotifyTemplate);
        this.getAttributes().put("replicate-notify-template", replicateNotifyTemplate);
        this.getAttributes().put("perform-take-on-notify", performTakeOnNotify);
        this.getAttributes().put("pass-array-as-is", passArrayAsIs);
        this.getAttributes().put("guaranteed", guaranteed);
        this.getAttributes().put("durable", durable);
    }

    public String getCommType() {
        return (String)this.getAttributes().get("comm-type");
    }

    public Boolean isFifo() {
        return (Boolean)this.getAttributes().get("fifo");
    }

    public Integer getBatchSize() {
        return (Integer)this.getAttributes().get("batch-size");
    }

    public Integer getBatchTime() {
        return (Integer)this.getAttributes().get("batch-time");
    }

    public Boolean isAutoRenew() {
        return (Boolean)this.getAttributes().get("auto-renew");
    }

    public Boolean isNotifyWrite() {
        return (Boolean)this.getAttributes().get("notify-write");
    }

    @Deprecated
    public Boolean isNotifyUpdate() {
        return (Boolean)this.getAttributes().get("notify-update");
    }

    public Boolean isNotifyTake() {
        return (Boolean)this.getAttributes().get("notify-take");
    }

    public Boolean isNotifyLeaseExpire() {
        return (Boolean)this.getAttributes().get("notify-lease-expire");
    }

    public Boolean isNotifyUnmatched() {
        return (Boolean)this.getAttributes().get("notify-unmatched");
    }

    public Boolean isNotifyMatched() {
        return (Boolean)this.getAttributes().get("notify-matched");
    }

    public Boolean isNotifyRematched() {
        return (Boolean)this.getAttributes().get("notify-rematched");
    }

    public Boolean isTriggerNotifyTemplate() {
        return (Boolean)this.getAttributes().get("trigger-notify-template");
    }

    public Boolean isReplicateNotifyTemplate() {
        return (Boolean)this.getAttributes().get("replicate-notify-template");
    }

    public Boolean isPerformTakeOnNotify() {
        return (Boolean)this.getAttributes().get("perform-take-on-notify");
    }

    public Boolean isPassArrayAsIs() {
        return (Boolean)this.getAttributes().get("pass-array-as-is");
    }

    public Boolean isGuaranteed() {
        return (Boolean)this.getAttributes().get("guaranteed");
    }

    public Boolean isDurable() {
        Boolean durable = (Boolean)this.getAttributes().get("durable");
        return durable == null ? Boolean.FALSE.booleanValue() : durable.booleanValue();
    }

    @Override
    public AggregatedServiceDetails aggregateById(ServiceDetails[] servicesDetails) {
        return new AggregatedNotifyEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public AggregatedServiceDetails aggregateByServiceSubType(ServiceDetails[] servicesDetails) {
        return new AggregatedNotifyEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes
    extends EventContainerServiceDetails.Attributes {
        public static final String COMM_TYPE = "comm-type";
        public static final String FIFO = "fifo";
        public static final String BATCH_SIZE = "batch-size";
        public static final String BATCH_TIME = "batch-time";
        public static final String BATCH_PENDING_THRESHOLD = "batch-pending-threshold";
        public static final String AUTO_RENEW = "auto-renew";
        public static final String NOTIFY_WRITE = "notify-write";
        public static final String NOTIFY_TAKE = "notify-take";
        @Deprecated
        public static final String NOTIFY_UPDATE = "notify-update";
        public static final String NOTIFY_LEASE_EXPIRE = "notify-lease-expire";
        public static final String NOTIFY_UNMATCHED = "notify-unmatched";
        public static final String NOTIFY_MATCHED = "notify-matched";
        public static final String NOTIFY_REMATCHED = "notify-rematched";
        public static final String TRIGGER_NOTIFY_TEMPLATE = "trigger-notify-template";
        public static final String REPLICATE_NOTIFY_TEMPLATE = "replicate-notify-template";
        public static final String PERFORM_TAKE_ON_NOTIFY = "perform-take-on-notify";
        public static final String PASS_ARRAY_AS_IS = "pass-array-as-is";
        public static final String GUARANTEED = "guaranteed";
        public static final String DURABLE = "durable";
    }
}

