/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.notify;

import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.events.IInternalEventSessionAdmin;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.lease.LeaseListener;
import org.openspaces.core.util.SpaceUtils;
import org.openspaces.events.AbstractEventListenerContainer;
import org.openspaces.events.notify.NotifyEventContainerServiceDetails;
import org.openspaces.events.notify.NotifyEventContainerServiceMonitors;
import org.openspaces.events.notify.NotifyListenerRegistrationException;
import org.openspaces.events.notify.NotifyTypeProvider;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.springframework.core.Constants;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.ClassUtils;

public class SimpleNotifyEventListenerContainer
extends AbstractEventListenerContainer {
    protected static final Constants constants = new Constants(SimpleNotifyEventListenerContainer.class);
    private boolean fifo = false;
    private Integer batchSize;
    private Integer batchTime;
    private Integer batchPendingThreshold;
    private boolean autoRenew = false;
    private long renewExpiration = Long.MAX_VALUE;
    private long renewDuration = 20000L;
    private long renewRTT = 10000L;
    private LeaseListener leaseListener;
    private long listenerLease = Long.MAX_VALUE;
    private INotifyDelegatorFilter notifyFilter;
    private Boolean notifyWrite;
    private Boolean notifyUpdate;
    private Boolean notifyTake;
    private Boolean notifyLeaseExpire;
    private Boolean notifyUnmatched;
    private Boolean notifyMatchedUpdate;
    private Boolean notifyRematchedUpdate;
    private Boolean notifyAll;
    private Boolean triggerNotifyTemplate;
    private Boolean replicateNotifyTemplate;
    private Boolean guaranteed;
    private boolean passArrayAsIs = false;
    private Boolean durable;
    private boolean performTakeOnNotify = false;
    private boolean ignoreEventOnNullTake = false;
    private DataEventSession dataEventSession;
    private EventRegistration eventRegistration;

    public SimpleNotifyEventListenerContainer() {
        this.setActiveWhenPrimary(false);
    }

    public void setFifo(boolean fifo) {
        this.fifo = fifo;
    }

    protected boolean isFifo() {
        return this.fifo;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    protected Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchTime(Integer batchTime) {
        this.batchTime = batchTime;
    }

    protected Integer getBatchTime() {
        return this.batchTime;
    }

    public void setBatchPendingThreshold(Integer batchPendingThreshold) {
        this.batchPendingThreshold = batchPendingThreshold;
    }

    protected Integer getBatchPendingThreshold() {
        return this.batchPendingThreshold;
    }

    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    protected boolean isAutoRenew() {
        return this.autoRenew;
    }

    @Deprecated
    protected long getRenewExpiration() {
        return this.renewExpiration;
    }

    @Deprecated
    public void setRenewExpiration(long renewExpiration) {
        this.renewExpiration = renewExpiration;
    }

    @Deprecated
    protected long getRenewDuration() {
        return this.renewDuration;
    }

    @Deprecated
    public void setRenewDuration(long renewDuration) {
        this.renewDuration = renewDuration;
    }

    @Deprecated
    protected long getRenewRTT() {
        return this.renewRTT;
    }

    @Deprecated
    public void setRenewRTT(long renewRTT) {
        this.renewRTT = renewRTT;
    }

    public void setLeaseListener(LeaseListener leaseListener) {
        this.leaseListener = leaseListener;
    }

    @Deprecated
    public void setListenerLease(long listenerLease) {
        this.listenerLease = listenerLease;
    }

    public void setNotifyFilter(INotifyDelegatorFilter notifyFilter) {
        this.notifyFilter = notifyFilter;
    }

    public void setNotifyWrite(Boolean notifyWrite) {
        this.notifyWrite = notifyWrite;
    }

    protected Boolean isNotifyWrite() {
        if (this.notifyWrite == null) {
            return Boolean.FALSE;
        }
        return this.notifyWrite;
    }

    public void setNotifyUpdate(Boolean notifyUpdate) {
        this.notifyUpdate = notifyUpdate;
    }

    protected Boolean isNotifyUpdate() {
        if (this.notifyUpdate == null) {
            return false;
        }
        return this.notifyUpdate;
    }

    public void setNotifyTake(Boolean notifyTake) {
        this.notifyTake = notifyTake;
    }

    protected Boolean isNotifyTake() {
        if (this.notifyTake == null) {
            return false;
        }
        return this.notifyTake;
    }

    public void setNotifyAll(Boolean notifyAll) {
        this.notifyAll = notifyAll;
    }

    protected Boolean isNotifyAll() {
        if (this.notifyAll == null) {
            return Boolean.FALSE;
        }
        return this.notifyAll;
    }

    public void setNotifyLeaseExpire(Boolean notifyLeaseExpire) {
        this.notifyLeaseExpire = notifyLeaseExpire;
    }

    protected Boolean isNotifyLeaseExpire() {
        if (this.notifyLeaseExpire == null) {
            return Boolean.FALSE;
        }
        return this.notifyLeaseExpire;
    }

    public void setNotifyUnmatched(Boolean notifyUnmatched) {
        this.notifyUnmatched = notifyUnmatched;
    }

    public void setNotifyMatchedUpdate(Boolean notifyMatchedUpdate) {
        this.notifyMatchedUpdate = notifyMatchedUpdate;
    }

    public void setNotifyRematchedUpdate(Boolean notifyRematchedUpdate) {
        this.notifyRematchedUpdate = notifyRematchedUpdate;
    }

    protected Boolean isNotifyUnmatched() {
        if (this.notifyUnmatched == null) {
            return Boolean.FALSE;
        }
        return this.notifyUnmatched;
    }

    protected Boolean isNotifyMatchedUpdate() {
        if (this.notifyMatchedUpdate == null) {
            return Boolean.FALSE;
        }
        return this.notifyMatchedUpdate;
    }

    protected Boolean isNotifyRematchedUpdate() {
        if (this.notifyRematchedUpdate == null) {
            return Boolean.FALSE;
        }
        return this.notifyRematchedUpdate;
    }

    public void setTriggerNotifyTemplate(boolean triggerNotifyTemplate) {
        this.triggerNotifyTemplate = triggerNotifyTemplate;
    }

    protected Boolean isTriggerNotifyTemplate() {
        return this.triggerNotifyTemplate;
    }

    public void setReplicateNotifyTemplate(boolean replicateNotifyTemplate) {
        this.replicateNotifyTemplate = replicateNotifyTemplate;
    }

    protected Boolean isReplicateNotifyTemplate() {
        return this.replicateNotifyTemplate;
    }

    @Deprecated
    public void setGuaranteed(Boolean guaranteed) {
        if (EventSessionConfig.USE_OLD_GUARANTEED_NOTIFICATIONS) {
            this.guaranteed = guaranteed;
        } else {
            this.setDurable(guaranteed);
        }
    }

    protected Boolean isGuaranteed() {
        if (EventSessionConfig.USE_OLD_GUARANTEED_NOTIFICATIONS) {
            if (this.guaranteed == null) {
                return Boolean.FALSE;
            }
            return this.guaranteed;
        }
        return this.isDurable();
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    protected Boolean isDurable() {
        if (this.durable == null) {
            return Boolean.FALSE;
        }
        return this.durable;
    }

    public void setPassArrayAsIs(boolean passArrayAsIs) {
        this.passArrayAsIs = passArrayAsIs;
    }

    @Override
    public void setDynamicTemplate(Object templateProvider) {
        throw new UnsupportedOperationException("Notify container does not support dynamic event templates.");
    }

    protected boolean isPassArrayAsIs() {
        return this.passArrayAsIs;
    }

    protected Boolean getNotifyWrite() {
        return this.notifyWrite;
    }

    protected Boolean getNotifyUpdate() {
        return this.notifyUpdate;
    }

    protected Boolean getNotifyTake() {
        return this.notifyTake;
    }

    protected Boolean getNotifyLeaseExpire() {
        return this.notifyLeaseExpire;
    }

    protected Boolean getNotifyUnmatched() {
        return this.notifyUnmatched;
    }

    protected Boolean getNotifyMatchedUpdate() {
        return this.notifyMatchedUpdate;
    }

    protected Boolean getNotifyRematchedUpdate() {
        return this.notifyRematchedUpdate;
    }

    protected boolean isBatchEnabled() {
        return this.batchSize != null && this.batchTime != null || this.durable != null && this.durable != false || !EventSessionConfig.USE_OLD_GUARANTEED_NOTIFICATIONS && this.guaranteed != null && this.guaranteed != false;
    }

    public void setPerformTakeOnNotify(boolean performTakeOnNotify) {
        this.performTakeOnNotify = performTakeOnNotify;
    }

    public void setIgnoreEventOnNullTake(boolean ignoreEventOnNullTake) {
        this.ignoreEventOnNullTake = ignoreEventOnNullTake;
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        if (this.batchSize == null && this.batchTime != null) {
            throw new IllegalArgumentException("batchTime has value [" + this.batchTime + "] which enables batching. batchSize must have a value as well");
        }
        if (this.batchTime == null && this.batchSize != null) {
            throw new IllegalArgumentException("batchSize has value [" + this.batchSize + "] which enables batching. batchTime must have a value as well");
        }
    }

    @Override
    public void initialize() throws DataAccessException {
        if (!SpaceUtils.isRemoteProtocol(this.getGigaSpace().getSpace()) && this.replicateNotifyTemplate == null && !SpaceUtils.isRemoteProtocol(this.getGigaSpace().getSpace())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.message("Setting replicateNotifyTemplate to false since working with an embedded Space"));
            }
            this.replicateNotifyTemplate = Boolean.FALSE;
        }
        if (this.replicateNotifyTemplate == null && this.triggerNotifyTemplate != null && this.triggerNotifyTemplate.booleanValue()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.message("triggerNotifyTemplate is set, automatically setting replicateNotifyTemplate to true"));
            }
            this.replicateNotifyTemplate = Boolean.TRUE;
        }
        if (this.getTemplate() instanceof NotifyTypeProvider) {
            NotifyTypeProvider notifyTypeProvider = (NotifyTypeProvider)this.getTemplate();
            if (notifyTypeProvider.isLeaseExpire() != null && this.notifyLeaseExpire == null) {
                this.notifyLeaseExpire = notifyTypeProvider.isLeaseExpire();
            }
            if (notifyTypeProvider.isTake() != null && this.notifyTake == null) {
                this.notifyTake = notifyTypeProvider.isTake();
            }
            if (notifyTypeProvider.isUpdate() != null && this.notifyUpdate == null) {
                this.notifyUpdate = notifyTypeProvider.isUpdate();
            }
            if (notifyTypeProvider.isWrite() != null && this.notifyWrite == null) {
                this.notifyWrite = notifyTypeProvider.isWrite();
            }
            if (notifyTypeProvider.isUnmatched() != null && this.notifyUnmatched == null) {
                this.notifyUnmatched = notifyTypeProvider.isUnmatched();
            }
            if (notifyTypeProvider.isMatchedUpdate() != null && this.notifyMatchedUpdate == null) {
                this.notifyMatchedUpdate = notifyTypeProvider.isMatchedUpdate();
            }
            if (notifyTypeProvider.isRematchedUpdate() != null && this.notifyRematchedUpdate == null) {
                this.notifyRematchedUpdate = notifyTypeProvider.isRematchedUpdate();
            }
        }
        if (this.notifyAll == null && this.notifyTake == null && this.notifyUpdate == null && this.notifyWrite == null && this.notifyLeaseExpire == null && this.notifyUnmatched == null) {
            this.notifyWrite = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.message("No notify flag is set, setting write notify to true by default"));
            }
        }
        super.initialize();
    }

    @Override
    protected void doInitialize() throws DataAccessException {
    }

    @Override
    protected void doShutdown() throws DataAccessException {
        this.closeSession();
    }

    @Override
    protected void doAfterStart() throws DataAccessException {
        super.doAfterStart();
        this.registerListener();
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.getBeanName()).append("] ").append("Started");
            if (this.getTransactionManager() != null) {
                sb.append(" transactional");
            }
            sb.append(" notify event container");
            if (this.getTemplate() != null) {
                sb.append(", template ").append(ClassUtils.getShortName(this.getTemplate().getClass())).append("[").append(this.getTemplate()).append("]");
            } else {
                sb.append(", template [null]");
            }
            sb.append(", notifications [");
            if (this.getNotifyWrite() != null && this.getNotifyWrite().booleanValue()) {
                sb.append("write,");
            }
            if (this.getNotifyUpdate() != null && this.getNotifyUpdate().booleanValue()) {
                sb.append("update,");
            }
            if (this.getNotifyUnmatched() != null && this.getNotifyUnmatched().booleanValue()) {
                sb.append("unmatched,");
            }
            if (this.getNotifyMatchedUpdate() != null && this.getNotifyMatchedUpdate().booleanValue()) {
                sb.append("matchedUpdate,");
            }
            if (this.getNotifyRematchedUpdate() != null && this.getNotifyRematchedUpdate().booleanValue()) {
                sb.append("rematchedUpdate,");
            }
            if (this.getNotifyTake() != null && this.getNotifyTake().booleanValue()) {
                sb.append("take,");
            }
            if (this.getNotifyLeaseExpire() != null && this.getNotifyLeaseExpire().booleanValue()) {
                sb.append("leaseExpire,");
            }
            sb.append("]");
            this.logger.debug((Object)sb.toString());
        }
    }

    @Override
    protected void doBeforeStop() throws DataAccessException {
        super.doBeforeStop();
        this.closeSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Stopped notify event container");
        }
    }

    protected void registerListener() throws DataAccessException {
        if (this.dataEventSession != null) {
            return;
        }
        SpaceInitializationIndicator.setInitializer();
        try {
            this.dataEventSession = this.getGigaSpace().newDataEventSession(this.createEventSessionConfig());
            try {
                this.eventRegistration = this.isBatchEnabled() ? this.registerListener(this.dataEventSession, (RemoteEventListener)new BatchNotifyListenerDelegate()) : this.registerListener(this.dataEventSession, new NotifyListenerDelegate());
            }
            catch (NotifyListenerRegistrationException ex) {
                this.closeSession();
                throw ex;
            }
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
    }

    protected void closeSession() {
        if (this.dataEventSession != null) {
            try {
                this.dataEventSession.close();
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)this.message("Failed to close data event session"), (Throwable)e);
                }
            }
            finally {
                this.dataEventSession = null;
            }
        }
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        Object tempalte = this.getTemplate();
        if (!(tempalte instanceof Serializable)) {
            tempalte = null;
        }
        return new ServiceDetails[]{new NotifyEventContainerServiceDetails(this.beanName, this.getGigaSpace().getName(), tempalte, this.isPerformSnapshot(), this.getTransactionManagerName(), 1, this.isFifo(), this.getBatchSize(), this.getBatchTime(), this.getBatchPendingThreshold(), this.isAutoRenew(), this.isNotifyAll(), this.isNotifyWrite(), this.isNotifyUpdate(), this.isNotifyTake(), this.isNotifyLeaseExpire(), this.isNotifyUnmatched(), this.isNotifyMatchedUpdate(), this.isNotifyRematchedUpdate(), this.isTriggerNotifyTemplate(), this.isReplicateNotifyTemplate(), this.performTakeOnNotify, this.isPassArrayAsIs(), this.isGuaranteed(), this.isDurable())};
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new NotifyEventContainerServiceMonitors(this.beanName, this.getProcessedEvents(), this.getFailedEvents(), this.getStatus())};
    }

    public String getName() {
        return this.beanName;
    }

    @Override
    protected String getEventListenerContainerType() {
        return "Notify Container";
    }

    @Override
    protected void dump(PrintWriter writer) {
        super.dump(writer);
        StringBuilder notifications = new StringBuilder();
        if (this.isNotifyAll().booleanValue()) {
            notifications.append("ALL, ");
        }
        if (this.isNotifyWrite().booleanValue()) {
            notifications.append("WRITE, ");
        }
        if (this.isNotifyUpdate().booleanValue()) {
            notifications.append("UPDATE, ");
        }
        if (this.isNotifyTake().booleanValue()) {
            notifications.append("TAKE, ");
        }
        if (this.isNotifyLeaseExpire().booleanValue()) {
            notifications.append("LEASE, ");
        }
        if (this.isNotifyUnmatched().booleanValue()) {
            notifications.append("UNMATCHED, ");
        }
        if (this.isNotifyMatchedUpdate().booleanValue()) {
            notifications.append("MATCHED_UPDATE, ");
        }
        if (this.isNotifyRematchedUpdate().booleanValue()) {
            notifications.append("REMATCHED_UPDATE, ");
        }
        writer.println("Fifo                  : [" + this.isFifo() + "]");
        writer.println("Batching              : Size [" + this.getBatchSize() + "], Time [" + this.getBatchTime() + "]");
        writer.println("Auto Renew            : [" + this.isAutoRenew() + "]");
        writer.println("Notifications         : [" + notifications + "]");
        writer.println("Trigger Template      : [" + this.isTriggerNotifyTemplate() + "]");
        writer.println("Replication Template  : [" + this.isReplicateNotifyTemplate() + "]");
        writer.println("Perform Snapshot      : [" + this.isPerformSnapshot() + "]");
        writer.println("Pass Array            : [" + this.isPassArrayAsIs() + "]");
        writer.println("Durable               : [" + this.isDurable() + "]");
        if (this.isDurable().booleanValue() && this.eventRegistration != null && this.dataEventSession instanceof IInternalEventSessionAdmin) {
            writer.println("===== DURABLE =====");
            writer.println(((IInternalEventSessionAdmin)this.dataEventSession).dumpState(this.eventRegistration));
        }
    }

    protected EventSessionConfig createEventSessionConfig() throws IllegalArgumentException {
        Object possibleListener;
        EventSessionConfig eventSessionConfig = new EventSessionConfig();
        eventSessionConfig.setFifo(this.fifo);
        if (this.batchSize != null && this.batchTime != null) {
            if (this.batchPendingThreshold != null && this.batchPendingThreshold != -1) {
                eventSessionConfig.setBatch(this.batchSize.intValue(), (long)this.batchTime.intValue(), this.batchPendingThreshold.intValue());
            } else {
                eventSessionConfig.setBatch(this.batchSize.intValue(), (long)this.batchTime.intValue());
            }
        }
        if (this.leaseListener == null && (possibleListener = this.getActualEventListener()) instanceof LeaseListener) {
            this.leaseListener = (LeaseListener)possibleListener;
        }
        eventSessionConfig.setAutoRenew(this.autoRenew, this.leaseListener, this.renewExpiration, this.renewDuration, this.renewRTT);
        if (this.triggerNotifyTemplate != null) {
            eventSessionConfig.setTriggerNotifyTemplate(this.triggerNotifyTemplate.booleanValue());
        }
        if (this.replicateNotifyTemplate != null) {
            eventSessionConfig.setReplicateNotifyTemplate(this.replicateNotifyTemplate.booleanValue());
        }
        if (this.guaranteed != null) {
            eventSessionConfig.setGuaranteedNotifications(this.guaranteed.booleanValue());
        }
        if (this.durable != null) {
            eventSessionConfig.setDurableNotifications(this.durable.booleanValue());
        }
        return eventSessionConfig;
    }

    protected EventRegistration registerListener(DataEventSession dataEventSession, RemoteEventListener listener) throws NotifyListenerRegistrationException {
        NotifyActionType notifyType = NotifyActionType.NOTIFY_NONE;
        if (this.notifyWrite != null && this.notifyWrite.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_WRITE);
        }
        if (this.notifyUpdate != null && this.notifyUpdate.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_UPDATE);
        }
        if (this.notifyTake != null && this.notifyTake.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_TAKE);
        }
        if (this.notifyLeaseExpire != null && this.notifyLeaseExpire.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_LEASE_EXPIRATION);
        }
        if (this.notifyUnmatched != null && this.notifyUnmatched.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_UNMATCHED);
        }
        if (this.notifyMatchedUpdate != null && this.notifyMatchedUpdate.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_MATCHED_UPDATE);
        }
        if (this.notifyRematchedUpdate != null && this.notifyRematchedUpdate.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_REMATCHED_UPDATE);
        }
        if (this.notifyAll != null && this.notifyAll.booleanValue()) {
            notifyType = notifyType.or(NotifyActionType.NOTIFY_ALL);
        }
        try {
            return dataEventSession.addListener(this.getReceiveTemplate(), listener, this.listenerLease, null, this.notifyFilter, notifyType);
        }
        catch (Exception e) {
            throw new NotifyListenerRegistrationException("Failed to register notify listener", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void invokeListenerWithTransaction(BatchRemoteEvent batchRemoteEvent, boolean performTakeOnNotify, boolean ignoreEventOnNullTake) throws DataAccessException {
        invokeListener = true;
        status = null;
        if (this.getTransactionManager() != null) {
            status = this.getTransactionManager().getTransaction((TransactionDefinition)this.getTransactionDefinition());
        }
        if (this.passArrayAsIs) {
            events = batchRemoteEvent.getEvents();
            eventData = new Object[events.length];
            try {
                for (i = 0; i < events.length; ++i) {
                    try {
                        eventData[i] = ((EntryArrivedRemoteEvent)events[i]).getObject();
                    }
                    catch (UnusableEntryException e) {
                        throw new org.openspaces.core.UnusableEntryException("Failure to get object from event [" + events[i] + "]", e);
                    }
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)this.message("Received event [" + eventData[i] + "]"));
                }
                if (performTakeOnNotify) {
                    if (ignoreEventOnNullTake) {
                        tempEventData = new ArrayList<Object>(eventData.length);
                        for (Object data : eventData) {
                            takeVal = this.getGigaSpace().take(data, 0L);
                            if (takeVal == null) continue;
                            tempEventData.add(data);
                        }
                        if (tempEventData.isEmpty()) {
                            invokeListener = false;
                        } else {
                            eventData = tempEventData.toArray(new Object[tempEventData.size()]);
                        }
                    } else {
                        for (Object data : eventData) {
                            this.getGigaSpace().take(data, 0L);
                        }
                    }
                }
                try {
                    if (!invokeListener) ** GOTO lbl89
                    this.invokeListener(this.getEventListener(), eventData, status, batchRemoteEvent);
                }
                catch (Throwable t) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Rolling back transaction because of listener exception thrown: " + t));
                    }
                    if (status != null) {
                        status.setRollbackOnly();
                    }
                    this.handleListenerException(t);
                }
            }
            catch (RuntimeException ex) {
                if (status != null) {
                    this.rollbackOnException(status, ex);
                }
                throw ex;
            }
            catch (Error err) {
                if (status != null) {
                    this.rollbackOnException(status, err);
                }
                throw err;
            }
        } else {
            for (RemoteEvent remoteEvent : batchRemoteEvent.getEvents()) {
                try {
                    try {
                        eventData = ((EntryArrivedRemoteEvent)remoteEvent).getObject();
                    }
                    catch (UnusableEntryException e) {
                        throw new org.openspaces.core.UnusableEntryException("Failure to get object from event [" + remoteEvent + "]", e);
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Received event [" + eventData + "]"));
                    }
                    if (performTakeOnNotify) {
                        takeVal = this.getGigaSpace().take(eventData, 0L);
                        if (ignoreEventOnNullTake && takeVal == null) {
                            invokeListener = false;
                        }
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("Performed take on notify, invoke listener is [" + invokeListener + "]"));
                        }
                    }
                    try {
                        if (!invokeListener) continue;
                        this.invokeListener(this.getEventListener(), eventData, status, remoteEvent);
                    }
                    catch (Throwable t) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)this.message("Rolling back transaction because of listener exception thrown: " + t));
                        }
                        if (status != null) {
                            status.setRollbackOnly();
                        }
                        this.handleListenerException(t);
                    }
                }
                catch (RuntimeException ex) {
                    if (status != null) {
                        this.rollbackOnException(status, ex);
                    }
                    throw ex;
                }
                catch (Error err) {
                    if (status != null) {
                        this.rollbackOnException(status, err);
                    }
                    throw err;
                }
            }
        }
lbl89:
        // 4 sources

        if (status != null && !status.isCompleted()) {
            if (status.isRollbackOnly()) {
                this.getTransactionManager().rollback(status);
            } else {
                this.getTransactionManager().commit(status);
            }
        }
    }

    protected void invokeListenerWithTransaction(Object eventData, Object source, boolean performTakeOnNotify, boolean ignoreEventOnNullTake) throws DataAccessException {
        boolean invokeListener = true;
        if (this.getTransactionManager() != null) {
            TransactionStatus status = this.getTransactionManager().getTransaction((TransactionDefinition)this.getTransactionDefinition());
            try {
                if (performTakeOnNotify) {
                    Object takeVal = this.getGigaSpace().take(eventData, 0L);
                    if (ignoreEventOnNullTake && takeVal == null) {
                        invokeListener = false;
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Performed take on notify, invoke listener is [" + invokeListener + "]"));
                    }
                }
                try {
                    if (invokeListener) {
                        this.invokeListener(this.getEventListener(), eventData, status, source);
                    }
                }
                catch (Throwable t) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Rolling back transaction because of listener exception thrown: " + t));
                    }
                    status.setRollbackOnly();
                    this.handleListenerException(t);
                }
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            if (!status.isCompleted()) {
                if (status.isRollbackOnly()) {
                    this.getTransactionManager().rollback(status);
                } else {
                    this.getTransactionManager().commit(status);
                }
            }
        } else {
            if (performTakeOnNotify) {
                Object takeVal = this.getGigaSpace().take(eventData, 0L);
                if (ignoreEventOnNullTake && takeVal == null) {
                    invokeListener = false;
                }
            }
            try {
                if (invokeListener) {
                    this.invokeListener(this.getEventListener(), eventData, null, source);
                }
            }
            catch (Throwable t) {
                this.handleListenerException(t);
            }
        }
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.message("Initiating transaction rollback on application exception"), ex);
        }
        try {
            this.getTransactionManager().rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)this.message("Application exception overridden by rollback exception"), ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)this.message("Application exception overridden by rollback error"), ex);
            throw err;
        }
    }

    private class BatchNotifyListenerDelegate
    implements BatchRemoteEventListener {
        private BatchNotifyListenerDelegate() {
        }

        public void notifyBatch(BatchRemoteEvent batchRemoteEvent) throws UnknownEventException, RemoteException {
            SimpleNotifyEventListenerContainer.this.invokeListenerWithTransaction(batchRemoteEvent, SimpleNotifyEventListenerContainer.this.performTakeOnNotify, SimpleNotifyEventListenerContainer.this.ignoreEventOnNullTake);
        }

        public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
            Object eventData;
            try {
                eventData = ((EntryArrivedRemoteEvent)remoteEvent).getObject();
            }
            catch (UnusableEntryException e) {
                throw new org.openspaces.core.UnusableEntryException("Failure to get object from event [" + remoteEvent + "]", e);
            }
            if (SimpleNotifyEventListenerContainer.this.logger.isTraceEnabled()) {
                SimpleNotifyEventListenerContainer.this.logger.trace((Object)SimpleNotifyEventListenerContainer.this.message("Received event [" + eventData + "]"));
            }
            SimpleNotifyEventListenerContainer.this.invokeListenerWithTransaction(eventData, remoteEvent, SimpleNotifyEventListenerContainer.this.performTakeOnNotify, SimpleNotifyEventListenerContainer.this.ignoreEventOnNullTake);
        }
    }

    private class NotifyListenerDelegate
    implements RemoteEventListener {
        private NotifyListenerDelegate() {
        }

        public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
            Object eventData;
            try {
                eventData = ((EntryArrivedRemoteEvent)remoteEvent).getObject();
            }
            catch (UnusableEntryException e) {
                throw new org.openspaces.core.UnusableEntryException("Failure to get object from event [" + remoteEvent + "]", e);
            }
            if (SimpleNotifyEventListenerContainer.this.logger.isTraceEnabled()) {
                SimpleNotifyEventListenerContainer.this.logger.trace((Object)SimpleNotifyEventListenerContainer.this.message("Received event [" + eventData + "]"));
            }
            SimpleNotifyEventListenerContainer.this.invokeListenerWithTransaction(eventData, remoteEvent, SimpleNotifyEventListenerContainer.this.performTakeOnNotify, SimpleNotifyEventListenerContainer.this.ignoreEventOnNullTake);
        }
    }
}

