/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.notify.config;

import com.j_spaces.core.client.INotifyDelegatorFilter;
import net.jini.lease.LeaseListener;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.util.AnnotationUtils;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.TransactionalEvent;
import org.openspaces.events.notify.Notify;
import org.openspaces.events.notify.NotifyBatch;
import org.openspaces.events.notify.NotifyLease;
import org.openspaces.events.notify.NotifyType;
import org.openspaces.events.notify.ReplicateNotifyTemplateType;
import org.openspaces.events.notify.SimpleNotifyContainerConfigurer;
import org.openspaces.events.notify.TriggerNotifyTemplateType;
import org.openspaces.events.support.AnnotationProcessorUtils;
import org.openspaces.events.support.EventContainersBus;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class NotifyAnnotationPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        NotifyLease notifyLease;
        NotifyBatch notifyBatch;
        NotifyType notifyType;
        if (bean == null) {
            return bean;
        }
        Class<?> beanClass = this.getBeanClass(bean);
        if (beanClass == null) {
            return bean;
        }
        Notify notify = AnnotationUtils.findAnnotation(beanClass, Notify.class);
        if (notify == null) {
            return bean;
        }
        GigaSpace gigaSpace = AnnotationProcessorUtils.findGigaSpace(bean, notify.gigaSpace(), this.applicationContext, beanName);
        EventContainersBus eventContainersBus = AnnotationProcessorUtils.findBus(this.applicationContext);
        SimpleNotifyContainerConfigurer notifyContainerConfigurer = new SimpleNotifyContainerConfigurer(gigaSpace);
        notifyContainerConfigurer.name(beanName);
        if (bean instanceof SpaceDataEventListener) {
            notifyContainerConfigurer.eventListener((SpaceDataEventListener)bean);
        } else {
            notifyContainerConfigurer.eventListenerAnnotation(bean);
        }
        notifyContainerConfigurer.performSnapshot(notify.performSnapshot());
        notifyContainerConfigurer.ignoreEventOnNullTake(notify.ignoreEventOnNullTake());
        notifyContainerConfigurer.performTakeOnNotify(notify.performTakeOnNotify());
        notifyContainerConfigurer.guaranteed(notify.guaranteed());
        notifyContainerConfigurer.durable(notify.durable());
        notifyContainerConfigurer.fifo(notify.fifo());
        notifyContainerConfigurer.passArrayAsIs(notify.passArrayAsIs());
        notifyContainerConfigurer.autoStart(notify.autoStart());
        if (notify.replicateNotifyTemplate() != ReplicateNotifyTemplateType.DEFAULT) {
            notifyContainerConfigurer.replicateNotifyTemplate(notify.replicateNotifyTemplate() == ReplicateNotifyTemplateType.TRUE);
        }
        if (notify.triggerNotifyTemplate() != TriggerNotifyTemplateType.DEFAULT) {
            notifyContainerConfigurer.triggerNotifyTemplate(notify.triggerNotifyTemplate() == TriggerNotifyTemplateType.TRUE);
        }
        if (!INotifyDelegatorFilter.class.equals(notify.notifyFilter())) {
            try {
                INotifyDelegatorFilter filter = notify.notifyFilter().newInstance();
                notifyContainerConfigurer.notifyFilter(filter);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create [" + notify.notifyFilter() + "]", e);
            }
        }
        TransactionalEvent transactionalEvent = AnnotationUtils.findAnnotation(beanClass, TransactionalEvent.class);
        Transactional transactional = AnnotationUtils.findAnnotation(beanClass, Transactional.class);
        if (transactionalEvent != null || transactional != null) {
            if (transactionalEvent != null) {
                notifyContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager(transactionalEvent.transactionManager(), this.applicationContext, beanName));
            } else {
                notifyContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager("", this.applicationContext, beanName));
            }
            Isolation isolation = Isolation.DEFAULT;
            if (transactional != null && transactional.isolation() != Isolation.DEFAULT) {
                isolation = transactional.isolation();
            }
            if (transactionalEvent != null && transactionalEvent.isolation() != Isolation.DEFAULT) {
                isolation = transactionalEvent.isolation();
            }
            notifyContainerConfigurer.transactionIsolationLevel(isolation.value());
            int timeout = -1;
            if (transactional != null && transactional.timeout() != -1) {
                timeout = transactional.timeout();
            }
            if (transactionalEvent != null && transactionalEvent.timeout() != -1) {
                timeout = transactionalEvent.timeout();
            }
            notifyContainerConfigurer.transactionTimeout(timeout);
        }
        if ((notifyType = AnnotationUtils.findAnnotation(beanClass, NotifyType.class)) != null) {
            notifyContainerConfigurer.notifyWrite(notifyType.write());
            notifyContainerConfigurer.notifyUpdate(notifyType.update());
            notifyContainerConfigurer.notifyTake(notifyType.take());
            notifyContainerConfigurer.notifyLeaseExpire(notifyType.leaseExpire());
            notifyContainerConfigurer.notifyUnmatched(notifyType.unmatched());
            notifyContainerConfigurer.notifyMatchedUpdate(notifyType.matchedUpdate());
            notifyContainerConfigurer.notifyRematchedUpdate(notifyType.rematchedUpdate());
        }
        if ((notifyBatch = AnnotationUtils.findAnnotation(beanClass, NotifyBatch.class)) != null) {
            notifyContainerConfigurer.batchSize(notifyBatch.size());
            notifyContainerConfigurer.batchTime(notifyBatch.time());
            notifyContainerConfigurer.batchPendingThreshold(notifyBatch.pendingThreshold());
            notifyContainerConfigurer.passArrayAsIs(notifyBatch.passArrayAsIs());
        }
        if ((notifyLease = AnnotationUtils.findAnnotation(beanClass, NotifyLease.class)) != null) {
            notifyContainerConfigurer.autoRenew(true);
            notifyContainerConfigurer.listenerLease(notifyLease.lease());
            notifyContainerConfigurer.renewExpiration(notifyLease.renewExpiration());
            notifyContainerConfigurer.renewDuration(notifyLease.renewDuration());
            notifyContainerConfigurer.renewRTT(notifyLease.renewRTT());
            if (!LeaseListener.class.equals(notifyLease.leaseListener())) {
                try {
                    LeaseListener leaseListener = notifyLease.leaseListener().newInstance();
                    notifyContainerConfigurer.leaseListener(leaseListener);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to create [" + notifyLease.leaseListener() + "]", e);
                }
            }
        }
        eventContainersBus.registerContainer(beanName, notifyContainerConfigurer.notifyContainer());
        return bean;
    }

    private Class<?> getBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

