/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.events.polling.PollingEventContainerServiceDetails;
import org.openspaces.pu.service.PlainAggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class AggregatedPollingEventContainerServiceDetails
extends PlainAggregatedServiceDetails {
    private static final long serialVersionUID = -4531279106221740074L;

    public AggregatedPollingEventContainerServiceDetails() {
    }

    public AggregatedPollingEventContainerServiceDetails(String serviceType, ServiceDetails[] details) {
        super(serviceType, details);
        int concurrentConsumers = 0;
        int maxConcurrentConsumers = 0;
        for (ServiceDetails detail : details) {
            if (!(detail instanceof PollingEventContainerServiceDetails)) {
                throw new IllegalArgumentException("Details [" + detail.getClass().getName() + "] is of wrong type");
            }
            PollingEventContainerServiceDetails pollingServiceDetails = (PollingEventContainerServiceDetails)detail;
            concurrentConsumers += pollingServiceDetails.getConcurrentConsumers().intValue();
            maxConcurrentConsumers += pollingServiceDetails.getMaxConcurrentConsumers().intValue();
        }
        this.getAttributes().put("concurrent-consumers", concurrentConsumers);
        this.getAttributes().put("max-concurrent-consumers", maxConcurrentConsumers);
    }

    public long getReceiveTimeout() {
        return (Long)this.getAttributes().get("receive-timeout");
    }

    public String getReceiveOperationHandler() {
        return (String)this.getAttributes().get("receive-operating-handler");
    }

    public String getTriggerOperationHandler() {
        return (String)this.getAttributes().get("trigger-operating-handler");
    }

    public int getConcurrentConsumers() {
        return (Integer)this.getAttributes().get("concurrent-consumers");
    }

    public int getMaxConcurrentConsumers() {
        return (Integer)this.getAttributes().get("max-concurrent-consumers");
    }

    public boolean isPassArrayAsIs() {
        return (Boolean)this.getAttributes().get("pass-array-as-is");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes {
        public static final String RECEIVE_TIMEOUT = "receive-timeout";
        public static final String RECEIVE_OPERATION_HANDLER = "receive-operating-handler";
        public static final String TRIGGER_OPERATION_HANDLER = "trigger-operating-handler";
        public static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
        public static final String MAX_CONCURRENT_CONSUMERS = "max-concurrent-consumers";
        public static final String PASS_ARRAY_AS_IS = "pass-array-as-is";
        public static final String TEMPLATE = "template";
    }
}

