/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.events.EventContainerServiceDetails;
import org.openspaces.events.polling.AggregatedPollingEventContainerServiceDetails;
import org.openspaces.pu.service.AggregatedServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class PollingEventContainerServiceDetails
extends EventContainerServiceDetails {
    private static final long serialVersionUID = 6240507580002461248L;
    public static final String SERVICE_SUB_TYPE = "polling";

    public PollingEventContainerServiceDetails() {
    }

    public PollingEventContainerServiceDetails(String id, String gigaSpace, Object template, boolean performSnapshot, String transactionManager, long receiveTimeout, String receiveOperationHandler, String triggerOperationHandler, int concurrentConsumers, int maxConcurrentConsumers, boolean passArrayAsIs, boolean dynamicTemplate, int keepAliveRetries) {
        super(id, SERVICE_SUB_TYPE, gigaSpace, "Polling event container", "Polling event container, template [" + template + "]", template, performSnapshot, transactionManager);
        this.getAttributes().put("receive-timeout", receiveTimeout);
        this.getAttributes().put("receive-operating-handler", receiveOperationHandler);
        this.getAttributes().put("trigger-operating-handler", triggerOperationHandler);
        this.getAttributes().put("concurrent-consumers", concurrentConsumers);
        this.getAttributes().put("max-concurrent-consumers", maxConcurrentConsumers);
        this.getAttributes().put("pass-array-as-is", passArrayAsIs);
        this.getAttributes().put("keep-alive-retries", keepAliveRetries);
        this.getAttributes().put("dynamic-template", dynamicTemplate);
    }

    public Long getReceiveTimeout() {
        return (Long)this.getAttributes().get("receive-timeout");
    }

    public String getReceiveOperationHandler() {
        return (String)this.getAttributes().get("receive-operating-handler");
    }

    public String getTriggerOperationHandler() {
        return (String)this.getAttributes().get("trigger-operating-handler");
    }

    public Integer getConcurrentConsumers() {
        return (Integer)this.getAttributes().get("concurrent-consumers");
    }

    public Integer getMaxConcurrentConsumers() {
        return (Integer)this.getAttributes().get("max-concurrent-consumers");
    }

    public Boolean isPassArrayAsIs() {
        return (Boolean)this.getAttributes().get("pass-array-as-is");
    }

    public Boolean isDynamicTemplate() {
        return (Boolean)this.getAttributes().get("dynamic-template");
    }

    public Integer getKeepAliveRetries() {
        return (Integer)this.getAttributes().get("keep-alive-retries");
    }

    @Override
    public AggregatedServiceDetails aggregateByServiceSubType(ServiceDetails[] servicesDetails) {
        return new AggregatedPollingEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public AggregatedServiceDetails aggregateById(ServiceDetails[] servicesDetails) {
        return new AggregatedPollingEventContainerServiceDetails(this.serviceType, servicesDetails);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static class Attributes
    extends EventContainerServiceDetails.Attributes {
        public static final String RECEIVE_TIMEOUT = "receive-timeout";
        public static final String RECEIVE_OPERATION_HANDLER = "receive-operating-handler";
        public static final String TRIGGER_OPERATION_HANDLER = "trigger-operating-handler";
        public static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
        public static final String MAX_CONCURRENT_CONSUMERS = "max-concurrent-consumers";
        public static final String PASS_ARRAY_AS_IS = "pass-array-as-is";
        public static final String KEEP_ALIVE_RETRIES = "keep-alive-retries";
        public static final String DYNAMIC_TEMPLATE = "dynamic-template";
    }
}

