/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling;

import com.gigaspaces.admin.quiesce.QuiesceException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.core.SpaceInterruptedException;
import org.openspaces.events.AbstractEventListenerContainer;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.polling.PollingEventContainerServiceDetails;
import org.openspaces.events.polling.PollingEventContainerServiceMonitors;
import org.openspaces.events.polling.ReceiveHandler;
import org.openspaces.events.polling.TriggerHandler;
import org.openspaces.events.polling.receive.ReceiveOperationHandler;
import org.openspaces.events.polling.receive.SingleTakeReceiveOperationHandler;
import org.openspaces.events.polling.trigger.TriggerOperationHandler;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SimplePollingEventListenerContainer
extends AbstractEventListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(SimplePollingEventListenerContainer.class) + "-";
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final int DEFAULT_KEEP_ALIVE_RETRIES = 3;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 60000L;
    private boolean passArrayAsIs = false;
    private long receiveTimeout = 60000L;
    private ReceiveOperationHandler receiveOperationHandler;
    private TriggerOperationHandler triggerOperationHandler;
    private TaskExecutor taskExecutor;
    private long recoveryInterval = 5000L;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int maxEventsPerTask = Integer.MIN_VALUE;
    private int idleTaskExecutionLimit = 1;
    private final Set<AsyncEventListenerInvoker> scheduledInvokers = new HashSet<AsyncEventListenerInvoker>();
    private AtomicInteger activeInvokerCount = new AtomicInteger(0);
    private final Object activeInvokerMonitor = new Object();
    private Object currentRecoveryMarker = new Object();
    private final Object recoveryMonitor = new Object();
    private int keepAliveRetries = 3;

    @Override
    protected void validateConfiguration() {
        int timeout;
        super.validateConfiguration();
        if (!this.disableTransactionValidation && this.getTransactionManager() != null && this.getGigaSpace().getTxProvider().isEnabled() && this.getTransactionDefinition() != null && (timeout = this.getTransactionDefinition().getTimeout()) != -1 && (long)(timeout * 1000) <= this.getReceiveTimeout()) {
            throw new IllegalStateException("Receive timeout [" + this.getReceiveTimeout() + "ms] must be lower than the transaction timeout [" + this.getTransactionDefinition().getTimeout() * 1000 + "ms]");
        }
    }

    public void setPassArrayAsIs(boolean passArrayAsIs) {
        this.passArrayAsIs = passArrayAsIs;
    }

    protected boolean isPassArrayAsIs() {
        return this.passArrayAsIs;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    protected long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveOperationHandler(ReceiveOperationHandler receiveOperationHandler) {
        this.receiveOperationHandler = receiveOperationHandler;
    }

    protected ReceiveOperationHandler getReceiveOperationHandler() {
        return this.receiveOperationHandler;
    }

    public void setTriggerOperationHandler(TriggerOperationHandler triggerOperationHandler) {
        this.triggerOperationHandler = triggerOperationHandler;
    }

    protected TriggerOperationHandler getTriggerOperationHandler() {
        return this.triggerOperationHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setKeepAliveRetries(int keepAliveRetries) {
        this.keepAliveRetries = keepAliveRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"'concurrentConsumers' value must be at least 1 (one)");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.concurrentConsumers = concurrentConsumers;
            if (this.maxConcurrentConsumers < concurrentConsumers) {
                this.maxConcurrentConsumers = concurrentConsumers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConcurrentConsumers() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue((maxConcurrentConsumers > 0 ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 1 (one)");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.maxConcurrentConsumers = maxConcurrentConsumers > this.concurrentConsumers ? maxConcurrentConsumers : this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxConcurrentConsumers() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.maxConcurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEventsPerTask(int maxEventsPerTask) {
        Assert.isTrue((maxEventsPerTask != 0 ? 1 : 0) != 0, (String)"'maxEventsPerTask' must not be 0");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.maxEventsPerTask = maxEventsPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEventsPerTask() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.maxEventsPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        Assert.isTrue((idleTaskExecutionLimit > 0 ? 1 : 0) != 0, (String)"'idleTaskExecutionLimit' must be 1 or higher");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleTaskExecutionLimit() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.idleTaskExecutionLimit;
        }
    }

    public int getKeepAliveRetries() {
        return this.keepAliveRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            if (this.taskExecutor == null) {
                this.taskExecutor = this.createDefaultTaskExecutor();
            } else if (this.taskExecutor instanceof SchedulingTaskExecutor && ((SchedulingTaskExecutor)this.taskExecutor).prefersShortLivedTasks() && this.maxEventsPerTask == Integer.MIN_VALUE) {
                this.maxEventsPerTask = 1;
            }
        }
        this.initReceiveOperationHandler();
        this.initTriggerOperationHandler();
        super.initialize();
        object = this.activeInvokerMonitor;
        synchronized (object) {
            for (int i = 0; i < this.concurrentConsumers; ++i) {
                this.scheduleNewInvoker();
            }
        }
    }

    private void initTriggerOperationHandler() {
        if (this.triggerOperationHandler == null && this.getActualEventListener() != null) {
            final AtomicReference ref = new AtomicReference();
            ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)this.getActualEventListener()), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (method.isAnnotationPresent(TriggerHandler.class)) {
                        ref.set(method);
                    }
                }
            });
            if (ref.get() != null) {
                ((Method)ref.get()).setAccessible(true);
                try {
                    this.setTriggerOperationHandler((TriggerOperationHandler)((Method)ref.get()).invoke(this.getActualEventListener(), new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to set ReceiveOperationHandler from method [" + ((Method)ref.get()).getName() + "]", e);
                }
            }
        }
    }

    private void initReceiveOperationHandler() {
        if (this.receiveOperationHandler == null) {
            if (this.getActualEventListener() != null) {
                final AtomicReference ref = new AtomicReference();
                ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)this.getActualEventListener()), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                        if (method.isAnnotationPresent(ReceiveHandler.class)) {
                            ref.set(method);
                        }
                    }
                });
                if (ref.get() != null) {
                    ((Method)ref.get()).setAccessible(true);
                    try {
                        this.setReceiveOperationHandler((ReceiveOperationHandler)((Method)ref.get()).invoke(this.getActualEventListener(), new Object[0]));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to set ReceiveOperationHandler from method [" + ((Method)ref.get()).getName() + "]", e);
                    }
                }
            }
            if (this.receiveOperationHandler == null) {
                this.receiveOperationHandler = new SingleTakeReceiveOperationHandler();
            }
        }
    }

    @Override
    protected void doAfterStart() throws DataAccessException {
        super.doAfterStart();
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.getBeanName()).append("] ").append("Started");
            if (this.getTransactionManager() != null) {
                sb.append(" transactional");
            }
            sb.append(" polling event container");
            sb.append(" with receiveTimeout [").append(this.getReceiveTimeout()).append("]");
            if (this.getTemplate() != null) {
                sb.append(", template ").append(ClassUtils.getShortName(this.getTemplate().getClass())).append("[").append(this.getTemplate()).append("]");
            } else {
                sb.append(", template [null]");
            }
            sb.append(", concurrentConsumers [").append(this.concurrentConsumers).append("]");
            if (this.maxConcurrentConsumers != this.concurrentConsumers) {
                sb.append(", maxConcurrentConsumers [").append(this.maxConcurrentConsumers).append("]");
            }
            this.logger.debug((Object)sb.toString());
        }
    }

    @Override
    protected void doBeforeStop() throws DataAccessException {
        super.doBeforeStop();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Stopped polling event container");
        }
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName = this.getBeanName();
        String threadNamePrefix = "GS-" + (beanName != null ? beanName + "-" : DEFAULT_THREAD_NAME_PREFIX);
        return new SimpleAsyncTaskExecutor(threadNamePrefix);
    }

    @Override
    protected void doRescheduleTask(Object task) {
        this.taskExecutor.execute((Runnable)task);
    }

    protected void eventReceived(Object event) {
        this.scheduleNewInvokerIfAppropriate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleNewInvokerIfAppropriate() {
        if (this.isRunning()) {
            Object object = this.activeInvokerMonitor;
            synchronized (object) {
                if (this.scheduledInvokers.size() < this.maxConcurrentConsumers && !this.hasIdleInvokers()) {
                    this.scheduleNewInvoker();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)this.message("Raised scheduled invoker count [" + this.scheduledInvokers.size() + "]"));
                    }
                }
            }
        }
    }

    private void scheduleNewInvoker() {
        AsyncEventListenerInvoker invoker = new AsyncEventListenerInvoker();
        this.taskExecutor.execute((Runnable)((Object)invoker));
        this.scheduledInvokers.add(invoker);
        this.activeInvokerMonitor.notifyAll();
    }

    private boolean hasIdleInvokers() {
        for (AsyncEventListenerInvoker invoker : this.scheduledInvokers) {
            if (!invoker.isIdle()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRescheduleInvoker(int idleTaskExecutionCount) {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            boolean idle = idleTaskExecutionCount >= this.idleTaskExecutionLimit;
            return this.scheduledInvokers.size() <= (idle ? this.concurrentConsumers : this.maxConcurrentConsumers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getScheduledConsumerCount() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.scheduledInvokers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getActiveConsumerCount() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.activeInvokerCount.get();
        }
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        if (ex instanceof Exception) {
            this.invokeExceptionListener((Exception)ex);
        }
        if (alreadyRecovered) {
            this.logger.debug((Object)this.message("Setup of event listener invoker failed - already recovered by other invoker"), ex);
        } else {
            this.logger.error((Object)this.message("Setup of event listener invoker failed - trying to recover"), ex);
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        this.refreshConnectionUntilSuccessful();
    }

    protected void refreshConnectionUntilSuccessful() {
        this.sleepInbetweenRecoveryAttempts();
    }

    protected void sleepInbetweenRecoveryAttempts() {
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException interEx) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void doInitialize() throws DataAccessException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() throws DataAccessException {
        this.logger.debug((Object)this.message("Waiting for shutdown of event listener invokers"));
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            for (AsyncEventListenerInvoker invoker : this.scheduledInvokers) {
                invoker.interrupt();
            }
            while (this.activeInvokerCount.get() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.message("Still waiting for shutdown of [" + this.activeInvokerCount + "] event listener invokers"));
                }
                try {
                    this.activeInvokerMonitor.wait();
                }
                catch (InterruptedException interEx) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        Object tempalte = this.getTemplate();
        if (!(tempalte instanceof Serializable)) {
            tempalte = null;
        }
        return new ServiceDetails[]{new PollingEventContainerServiceDetails(this.beanName, this.getGigaSpace().getName(), tempalte, this.isPerformSnapshot(), this.getTransactionManagerName(), this.getReceiveTimeout(), this.getReceiveOperationHandler().toString(), this.getTriggerOperationHandler() != null ? this.getTriggerOperationHandler().toString() : null, this.getConcurrentConsumers(), this.getMaxConcurrentConsumers(), this.isPassArrayAsIs(), this.isDynamicTemplate(), this.getKeepAliveRetries())};
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new PollingEventContainerServiceMonitors(this.beanName, this.getProcessedEvents(), this.getFailedEvents(), this.getStatus(), this.getConcurrentConsumers())};
    }

    public String getName() {
        return this.beanName;
    }

    @Override
    protected String getEventListenerContainerType() {
        return "Polling Container";
    }

    @Override
    protected void dump(PrintWriter writer) {
        super.dump(writer);
        writer.println("Receive Timeout       : [" + this.getReceiveTimeout() + "]");
        writer.println("Receive Handler       : [" + this.getReceiveOperationHandler().toString() + "]");
        if (this.getTriggerOperationHandler() != null) {
            writer.println("Trigger Handler       : [" + this.getTriggerOperationHandler().toString() + "]");
        }
        writer.println("Consumers             : [" + this.getConcurrentConsumers() + "]");
        writer.println("Max Consumers         : [" + this.getMaxConcurrentConsumers() + "]");
        writer.println("Pass Array            : [" + this.isPassArrayAsIs() + "]");
    }

    protected boolean receiveAndExecute(SpaceDataEventListener eventListener) throws Throwable, TransactionException {
        Object template = this.getReceiveTemplate();
        if (this.triggerOperationHandler != null) {
            Object trigger;
            try {
                trigger = this.triggerOperationHandler.triggerReceive(template, this.getGigaSpace(), this.receiveTimeout);
            }
            catch (SpaceInterruptedException e) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.message("Trigger operation handler returned [" + trigger + "]"));
            }
            if (trigger == null) {
                return false;
            }
            if (this.triggerOperationHandler.isUseTriggerAsTemplate()) {
                template = trigger;
            }
        }
        if (this.getTransactionManager() != null) {
            boolean messageReceived;
            TransactionStatus status = this.getTransactionManager().getTransaction((TransactionDefinition)this.getTransactionDefinition());
            try {
                messageReceived = this.doReceiveAndExecute(eventListener, template, status);
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            if (!status.isCompleted()) {
                if (!messageReceived || status.isRollbackOnly()) {
                    this.getTransactionManager().rollback(status);
                } else {
                    this.getTransactionManager().commit(status);
                }
            }
            return messageReceived;
        }
        return this.doReceiveAndExecute(eventListener, template, null);
    }

    protected boolean doReceiveAndExecute(SpaceDataEventListener eventListener, Object template, TransactionStatus status) {
        Object dataEvent = this.receiveEvent(template);
        if (dataEvent != null) {
            if (dataEvent instanceof Object[] && !this.passArrayAsIs) {
                Object[] dataEvents;
                for (Object dataEvent1 : dataEvents = (Object[])dataEvent) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.message("Received event [" + dataEvent + "]"));
                    }
                    this.eventReceived(dataEvent1);
                    try {
                        this.invokeListener(eventListener, dataEvent1, status, null);
                    }
                    catch (Throwable ex) {
                        if (status != null) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)this.message("Rolling back transaction because of listener exception thrown: " + ex));
                            }
                            status.setRollbackOnly();
                            this.rollbackOnException(status, ex);
                            this.handleListenerException(ex);
                            return true;
                        }
                        this.handleListenerException(ex);
                    }
                }
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)this.message("Received event [" + dataEvent + "]"));
                }
                if (this.passArrayAsIs && !(dataEvent instanceof Object[])) {
                    Object dataEventArr = Array.newInstance(dataEvent.getClass(), 1);
                    Array.set(dataEventArr, 0, dataEvent);
                    dataEvent = dataEventArr;
                }
                this.eventReceived(dataEvent);
                try {
                    this.invokeListener(eventListener, dataEvent, status, null);
                }
                catch (Throwable ex) {
                    if (status != null) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)this.message("Rolling back transaction because of listener exception thrown: " + ex));
                        }
                        status.setRollbackOnly();
                    }
                    this.handleListenerException(ex);
                }
            }
            return true;
        }
        return false;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.trace((Object)this.message("Initiating transaction rollback on application exception"), ex);
        try {
            this.getTransactionManager().rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)this.message("Application exception overridden by rollback exception"), ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)this.message("Application exception overridden by rollback error"), ex);
            throw err;
        }
    }

    protected Object receiveEvent(Object template) throws DataAccessException {
        try {
            return this.receiveOperationHandler.receive(template, this.getGigaSpace(), this.getReceiveTimeout());
        }
        catch (SpaceInterruptedException e) {
            return null;
        }
        catch (QuiesceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.message("receiveEvent got QuiesceException"), (Throwable)e);
            } else {
                this.logger.info((Object)this.message("receiveEvent was interrupted because space is suspended"));
            }
            return null;
        }
    }

    private class AsyncEventListenerInvoker
    implements SchedulingAwareRunnable {
        private Object lastRecoveryMarker;
        private boolean lastEventSucceeded;
        private int idleTaskExecutionCount = 0;
        private volatile boolean idle = true;
        private Thread invokerThread;
        private int noReceivedEventCount = 0;
        private SpaceDataEventListener eventListener;

        private AsyncEventListenerInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean casSucceeded;
            boolean eventReceived;
            block24: {
                Object object = SimplePollingEventListenerContainer.this.activeInvokerMonitor;
                synchronized (object) {
                    this.invokerThread = Thread.currentThread();
                    SimplePollingEventListenerContainer.this.activeInvokerCount.incrementAndGet();
                    SimplePollingEventListenerContainer.this.activeInvokerMonitor.notifyAll();
                }
                eventReceived = false;
                casSucceeded = false;
                try {
                    if (SimplePollingEventListenerContainer.this.maxEventsPerTask < 0) {
                        while (SimplePollingEventListenerContainer.this.isActive() && !casSucceeded) {
                            int i;
                            SimplePollingEventListenerContainer.this.waitWhileNotRunning();
                            if (!SimplePollingEventListenerContainer.this.isActive()) continue;
                            eventReceived = this.invokeListener();
                            if (SimplePollingEventListenerContainer.this.activeInvokerCount.get() <= SimplePollingEventListenerContainer.this.concurrentConsumers) continue;
                            this.noReceivedEventCount = !eventReceived ? ++this.noReceivedEventCount : 0;
                            if (this.noReceivedEventCount < SimplePollingEventListenerContainer.this.keepAliveRetries || (i = SimplePollingEventListenerContainer.this.activeInvokerCount.get()) <= SimplePollingEventListenerContainer.this.concurrentConsumers) continue;
                            casSucceeded = SimplePollingEventListenerContainer.this.activeInvokerCount.compareAndSet(i, i - 1);
                        }
                    } else {
                        for (int eventCount = 0; SimplePollingEventListenerContainer.this.isRunning() && eventCount < SimplePollingEventListenerContainer.this.maxEventsPerTask; ++eventCount) {
                            eventReceived = this.invokeListener() || eventReceived;
                        }
                    }
                }
                catch (Throwable ex) {
                    this.clearResources();
                    if (!this.lastEventSucceeded) {
                        SimplePollingEventListenerContainer.this.sleepInbetweenRecoveryAttempts();
                    }
                    this.lastEventSucceeded = false;
                    boolean alreadyRecovered = false;
                    Object object2 = SimplePollingEventListenerContainer.this.recoveryMonitor;
                    synchronized (object2) {
                        if (this.lastRecoveryMarker == SimplePollingEventListenerContainer.this.currentRecoveryMarker) {
                            SimplePollingEventListenerContainer.this.handleListenerSetupFailure(ex, false);
                            SimplePollingEventListenerContainer.this.recoverAfterListenerSetupFailure();
                            SimplePollingEventListenerContainer.this.currentRecoveryMarker = new Object();
                        } else {
                            alreadyRecovered = true;
                        }
                    }
                    if (!alreadyRecovered) break block24;
                    SimplePollingEventListenerContainer.this.handleListenerSetupFailure(ex, true);
                }
            }
            Object object = SimplePollingEventListenerContainer.this.activeInvokerMonitor;
            synchronized (object) {
                if (!casSucceeded) {
                    SimplePollingEventListenerContainer.this.activeInvokerCount.decrementAndGet();
                }
                SimplePollingEventListenerContainer.this.activeInvokerMonitor.notifyAll();
            }
            this.idleTaskExecutionCount = !eventReceived ? ++this.idleTaskExecutionCount : 0;
            if (!SimplePollingEventListenerContainer.this.shouldRescheduleInvoker(this.idleTaskExecutionCount) || !SimplePollingEventListenerContainer.this.rescheduleTaskIfNecessary(this)) {
                object = SimplePollingEventListenerContainer.this.activeInvokerMonitor;
                synchronized (object) {
                    SimplePollingEventListenerContainer.this.scheduledInvokers.remove(this);
                    if (SimplePollingEventListenerContainer.this.logger.isDebugEnabled()) {
                        SimplePollingEventListenerContainer.this.logger.debug((Object)SimplePollingEventListenerContainer.this.message("Lowered scheduled invoker count [" + SimplePollingEventListenerContainer.this.scheduledInvokers.size() + "]"));
                    }
                    SimplePollingEventListenerContainer.this.activeInvokerMonitor.notifyAll();
                }
                this.clearResources();
            }
        }

        private boolean invokeListener() throws Throwable {
            this.initResourcesIfNecessary();
            if (this.eventListener == null) {
                this.eventListener = SimplePollingEventListenerContainer.this.getEventListener();
            }
            boolean eventReceived = SimplePollingEventListenerContainer.this.receiveAndExecute(this.eventListener);
            this.lastEventSucceeded = true;
            this.idle = !eventReceived;
            return eventReceived;
        }

        private void initResourcesIfNecessary() {
            this.updateRecoveryMarker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRecoveryMarker() {
            Object object = SimplePollingEventListenerContainer.this.recoveryMonitor;
            synchronized (object) {
                this.lastRecoveryMarker = SimplePollingEventListenerContainer.this.currentRecoveryMarker;
            }
        }

        private void clearResources() {
        }

        public boolean isLongLived() {
            return SimplePollingEventListenerContainer.this.maxEventsPerTask < 0;
        }

        public boolean isIdle() {
            return this.idle;
        }

        public void interrupt() {
            if (this.invokerThread != null) {
                this.invokerThread.interrupt();
            }
        }
    }
}

