/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.config;

import org.openspaces.core.GigaSpace;
import org.openspaces.core.util.AnnotationUtils;
import org.openspaces.events.DynamicEventTemplateProvider;
import org.openspaces.events.EventDriven;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.TransactionalEvent;
import org.openspaces.events.asyncpolling.AsyncPolling;
import org.openspaces.events.notify.Notify;
import org.openspaces.events.polling.Polling;
import org.openspaces.events.polling.SimplePollingContainerConfigurer;
import org.openspaces.events.support.AnnotationProcessorUtils;
import org.openspaces.events.support.EventContainersBus;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class PollingAnnotationPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return bean;
        }
        Class<?> beanClass = this.getBeanClass(bean);
        if (beanClass == null) {
            return bean;
        }
        Polling polling = AnnotationUtils.findAnnotation(beanClass, Polling.class);
        if (polling == null) {
            EventDriven eventDriven = AnnotationUtils.findAnnotation(beanClass, EventDriven.class);
            if (eventDriven == null) {
                return bean;
            }
            Notify notify = AnnotationUtils.findAnnotation(beanClass, Notify.class);
            if (notify != null) {
                return bean;
            }
            AsyncPolling asyncPolling = AnnotationUtils.findAnnotation(beanClass, AsyncPolling.class);
            if (asyncPolling != null) {
                return bean;
            }
            return bean;
        }
        GigaSpace gigaSpace = AnnotationProcessorUtils.findGigaSpace(bean, polling.gigaSpace(), this.applicationContext, beanName);
        EventContainersBus eventContainersBus = AnnotationProcessorUtils.findBus(this.applicationContext);
        SimplePollingContainerConfigurer pollingContainerConfigurer = new SimplePollingContainerConfigurer(gigaSpace);
        pollingContainerConfigurer.name(beanName);
        if (bean instanceof SpaceDataEventListener) {
            pollingContainerConfigurer.eventListener((SpaceDataEventListener)bean);
        } else {
            pollingContainerConfigurer.eventListenerAnnotation(bean);
        }
        DynamicEventTemplateProvider templateProvider = AnnotationProcessorUtils.findDynamicEventTemplateProvider(bean);
        if (templateProvider != null) {
            pollingContainerConfigurer.dynamicTemplate(templateProvider);
        }
        pollingContainerConfigurer.concurrentConsumers(polling.concurrentConsumers());
        pollingContainerConfigurer.maxConcurrentConsumers(polling.maxConcurrentConsumers());
        pollingContainerConfigurer.receiveTimeout(polling.receiveTimeout());
        pollingContainerConfigurer.performSnapshot(polling.performSnapshot());
        pollingContainerConfigurer.passArrayAsIs(polling.passArrayAsIs());
        pollingContainerConfigurer.recoveryInterval(polling.recoveryInterval());
        pollingContainerConfigurer.autoStart(polling.autoStart());
        pollingContainerConfigurer.keepAliveRetries(polling.keepAliveRetries());
        TransactionalEvent transactionalEvent = AnnotationUtils.findAnnotation(beanClass, TransactionalEvent.class);
        Transactional transactional = AnnotationUtils.findAnnotation(beanClass, Transactional.class);
        if (transactionalEvent != null || transactional != null) {
            if (transactionalEvent != null) {
                pollingContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager(transactionalEvent.transactionManager(), this.applicationContext, beanName));
            } else {
                pollingContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager("", this.applicationContext, beanName));
            }
            Isolation isolation = Isolation.DEFAULT;
            if (transactional != null && transactional.isolation() != Isolation.DEFAULT) {
                isolation = transactional.isolation();
            }
            if (transactionalEvent != null && transactionalEvent.isolation() != Isolation.DEFAULT) {
                isolation = transactionalEvent.isolation();
            }
            pollingContainerConfigurer.transactionIsolationLevel(isolation.value());
            int timeout = -1;
            if (transactional != null && transactional.timeout() != -1) {
                timeout = transactional.timeout();
            }
            if (transactionalEvent != null && transactionalEvent.timeout() != -1) {
                timeout = transactionalEvent.timeout();
            }
            pollingContainerConfigurer.transactionTimeout(timeout);
        }
        eventContainersBus.registerContainer(beanName, pollingContainerConfigurer.pollingContainer());
        return bean;
    }

    private Class<?> getBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

