/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import org.openspaces.core.GigaSpace;
import org.openspaces.core.SpaceInterruptedException;
import org.openspaces.events.polling.receive.ReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public abstract class AbstractNonBlockingReceiveOperationHandler
implements ReceiveOperationHandler {
    protected boolean nonBlocking = false;
    protected int nonBlockingFactor = 10;

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public void setNonBlockingFactor(int nonBlockingFactor) {
        this.nonBlockingFactor = nonBlockingFactor;
    }

    @Override
    public Object receive(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        if (!this.nonBlocking) {
            return this.doReceiveBlocking(template, gigaSpace, receiveTimeout);
        }
        long sleepTime = receiveTimeout / (long)this.nonBlockingFactor;
        for (int i = 0; i < this.nonBlockingFactor; ++i) {
            Object event = this.doReceiveNonBlocking(template, gigaSpace);
            if (event != null) {
                return event;
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                throw new SpaceInterruptedException("Interrupted while performing non blocking receive operation");
            }
        }
        return null;
    }

    protected abstract Object doReceiveBlocking(Object var1, GigaSpace var2, long var3) throws DataAccessException;

    protected abstract Object doReceiveNonBlocking(Object var1, GigaSpace var2) throws DataAccessException;
}

