/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import com.gigaspaces.client.ReadModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.polling.receive.AbstractFifoGroupingReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public class ExclusiveReadReceiveOperationHandler
extends AbstractFifoGroupingReceiveOperationHandler {
    @Override
    protected Object doReceiveBlocking(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers().add(ReadModifiers.EXCLUSIVE_READ_LOCK);
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(ReadModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.read(template, receiveTimeout, modifiers);
    }

    @Override
    protected Object doReceiveNonBlocking(Object template, GigaSpace gigaSpace) throws DataAccessException {
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers().add(ReadModifiers.EXCLUSIVE_READ_LOCK);
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(ReadModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.read(template, 0L, modifiers);
    }

    public String toString() {
        return "Single Exclusive Read, nonBlocking[" + this.nonBlocking + "], nonBlockingFactor[" + this.nonBlockingFactor + "], useFifoGroups[" + this.isUseFifoGrouping() + "], useMemoryOnlySearch[" + this.isUseMemoryOnlySearch() + "]";
    }
}

