/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import com.gigaspaces.client.ReadModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.polling.receive.AbstractFifoGroupingReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public class MultiExclusiveReadReceiveOperationHandler
extends AbstractFifoGroupingReceiveOperationHandler {
    private static final int DEFAULT_MAX_ENTRIES = 50;
    private int maxEntries = 50;

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    @Override
    protected Object doReceiveBlocking(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        Object[] results;
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers().add(ReadModifiers.EXCLUSIVE_READ_LOCK);
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(ReadModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        if ((results = gigaSpace.readMultiple(template, this.maxEntries, modifiers)) != null && results.length > 0) {
            return results;
        }
        return gigaSpace.read(template, receiveTimeout, modifiers);
    }

    @Override
    protected Object doReceiveNonBlocking(Object template, GigaSpace gigaSpace) throws DataAccessException {
        Object[] results;
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers().add(ReadModifiers.EXCLUSIVE_READ_LOCK);
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(ReadModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        if ((results = gigaSpace.readMultiple(template, this.maxEntries, modifiers)) != null && results.length > 0) {
            return results;
        }
        return null;
    }

    public String toString() {
        return "Multi Exclusive Read, maxEntries[" + this.maxEntries + "], nonBlocking[" + this.nonBlocking + "], nonBlockingFactor[" + this.nonBlockingFactor + "], useFifoGroups[" + this.isUseFifoGrouping() + "], useMemoryOnlySearch[" + this.isUseMemoryOnlySearch() + "]";
    }
}

