/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import com.gigaspaces.client.TakeModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.polling.receive.AbstractFifoGroupingReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public class MultiTakeReceiveOperationHandler
extends AbstractFifoGroupingReceiveOperationHandler {
    private static final int DEFAULT_MAX_ENTRIES = 50;
    private int maxEntries = 50;

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    @Override
    protected Object doReceiveBlocking(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        Object[] results;
        TakeModifiers modifiers = gigaSpace.getDefaultTakeModifiers();
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(TakeModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers.add(TakeModifiers.MEMORY_ONLY_SEARCH);
        }
        if ((results = gigaSpace.takeMultiple(template, this.maxEntries, modifiers)) != null && results.length > 0) {
            return results;
        }
        return gigaSpace.take(template, receiveTimeout, modifiers);
    }

    @Override
    protected Object doReceiveNonBlocking(Object template, GigaSpace gigaSpace) throws DataAccessException {
        Object[] results;
        TakeModifiers modifiers = gigaSpace.getDefaultTakeModifiers();
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(TakeModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(TakeModifiers.MEMORY_ONLY_SEARCH);
        }
        if ((results = gigaSpace.takeMultiple(template, this.maxEntries, modifiers)) != null && results.length > 0) {
            return results;
        }
        return null;
    }

    public String toString() {
        return "Multi Take, maxEntries[" + this.maxEntries + "], nonBlocking[" + this.nonBlocking + "], nonBlockingFactor[" + this.nonBlockingFactor + "], useFifoGroups[" + this.isUseFifoGrouping() + "], useMemoryOnlySearch[" + this.isUseMemoryOnlySearch() + "]";
    }
}

