/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import com.gigaspaces.client.ReadModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.polling.receive.AbstractMemoryOnlySearchReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public class SingleReadReceiveOperationHandler
extends AbstractMemoryOnlySearchReceiveOperationHandler {
    @Override
    protected Object doReceiveBlocking(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers();
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.read(template, receiveTimeout, modifiers);
    }

    @Override
    protected Object doReceiveNonBlocking(Object template, GigaSpace gigaSpace) throws DataAccessException {
        ReadModifiers modifiers = gigaSpace.getDefaultReadModifiers();
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(ReadModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.read(template, 0L, modifiers);
    }

    public String toString() {
        return "Single Read, nonBlocking[" + this.nonBlocking + "], nonBlockingFactor[" + this.nonBlockingFactor + "], useMemoryOnlySearch[" + this.isUseMemoryOnlySearch() + "]";
    }
}

