/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.polling.receive;

import com.gigaspaces.client.TakeModifiers;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.polling.receive.AbstractFifoGroupingReceiveOperationHandler;
import org.springframework.dao.DataAccessException;

public class SingleTakeReceiveOperationHandler
extends AbstractFifoGroupingReceiveOperationHandler {
    @Override
    protected Object doReceiveBlocking(Object template, GigaSpace gigaSpace, long receiveTimeout) throws DataAccessException {
        TakeModifiers modifiers = gigaSpace.getDefaultTakeModifiers();
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(TakeModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(TakeModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.take(template, receiveTimeout, modifiers);
    }

    @Override
    protected Object doReceiveNonBlocking(Object template, GigaSpace gigaSpace) throws DataAccessException {
        TakeModifiers modifiers = gigaSpace.getDefaultTakeModifiers();
        if (this.useFifoGrouping) {
            modifiers = modifiers.add(TakeModifiers.FIFO_GROUPING_POLL);
        }
        if (this.useMemoryOnlySearch) {
            modifiers = modifiers.add(TakeModifiers.MEMORY_ONLY_SEARCH);
        }
        return gigaSpace.take(template, 0L, modifiers);
    }

    public String toString() {
        return "Single Take, nonBlocking[" + this.nonBlocking + "], nonBlockingFactor[" + this.nonBlockingFactor + "], useFifoGroups[" + this.isUseFifoGrouping() + "], useMemoryOnlySearch[" + this.isUseMemoryOnlySearch() + "]";
    }
}

