/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.archive.ArchiveOperationHandler;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.DynamicEventTemplateProvider;
import org.openspaces.events.EventTemplate;
import org.openspaces.events.EventTemplateProvider;
import org.openspaces.events.adapter.AnnotationDynamicEventTemplateProviderAdapter;
import org.openspaces.events.support.EventContainersBus;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationProcessorUtils {
    private AnnotationProcessorUtils() {
    }

    public static EventContainersBus findBus(ApplicationContext applicationContext) {
        EventContainersBus ecb = null;
        Map eventContainerBuses = applicationContext.getBeansOfType(EventContainersBus.class);
        ecb = (EventContainersBus)eventContainerBuses.get("internal-eventContainerBus");
        if (ecb == null) {
            ecb = (EventContainersBus)eventContainerBuses.get("internal-archiveContainerBus");
        }
        if (ecb == null) {
            throw new IllegalArgumentException("No event container bus found, can't register polling container. Add <os-events:annotation-support> or <os-archive:annotation-support>");
        }
        return ecb;
    }

    public static GigaSpace findGigaSpace(Object bean, String gigaSpaceName, ApplicationContext applicationContext, String beanName) throws IllegalArgumentException {
        return AnnotationProcessorUtils.findRef(bean, gigaSpaceName, applicationContext, beanName, GigaSpace.class);
    }

    public static ArchiveOperationHandler findArchiveHandler(Object bean, String archiveHandlerName, ApplicationContext applicationContext, String beanName) throws IllegalArgumentException {
        return AnnotationProcessorUtils.findRef(bean, archiveHandlerName, applicationContext, beanName, ArchiveOperationHandler.class);
    }

    public static <T> T findRef(Object bean, String refName, ApplicationContext applicationContext, String beanName, Class<T> refClass) throws IllegalArgumentException {
        Object ref = null;
        if (StringUtils.hasLength((String)refName)) {
            ref = applicationContext.getBean(refName, refClass);
            if (ref == null) {
                throw new IllegalArgumentException("Failed to lookup " + refClass.getName() + " using name [" + refName + "] in bean [" + beanName + "]");
            }
            return (T)ref;
        }
        Map refs = applicationContext.getBeansOfType(refClass);
        if (refs.size() == 1) {
            return (T)refs.values().iterator().next();
        }
        throw new IllegalArgumentException("Failed to resolve " + refClass.getName() + " to use with event container, [" + beanName + "] does not specify one, has no fields of that type, and there are more than one " + refClass.getName() + " beans within the context");
    }

    public static PlatformTransactionManager findTxManager(String txManagerName, ApplicationContext applicationContext, String beanName) {
        PlatformTransactionManager txManager;
        if (StringUtils.hasLength((String)txManagerName)) {
            txManager = (PlatformTransactionManager)applicationContext.getBean(txManagerName);
            if (txManager == null) {
                throw new IllegalArgumentException("Failed to find transaction manager for name [" + txManagerName + "] in bean [" + beanName + "]");
            }
        } else {
            Map txManagers = applicationContext.getBeansOfType(PlatformTransactionManager.class);
            if (txManagers.size() == 1) {
                txManager = (PlatformTransactionManager)txManagers.values().iterator().next();
            } else {
                throw new IllegalArgumentException("More than one transaction manager defined in context, and no transactionManager specified, can't detect one");
            }
        }
        return txManager;
    }

    public static DynamicEventTemplateProvider findDynamicEventTemplateProvider(Object bean) {
        DynamicEventTemplateProvider provider = null;
        if (bean instanceof DynamicEventTemplateProvider) {
            provider = (DynamicEventTemplateProvider)bean;
        } else {
            AnnotationDynamicEventTemplateProviderAdapter adapter = new AnnotationDynamicEventTemplateProviderAdapter();
            adapter.setDelegate(bean);
            adapter.setFailSilentlyIfMethodNotFound(true);
            adapter.afterPropertiesSet();
            if (adapter.isMethodFound()) {
                provider = adapter;
            }
        }
        return provider;
    }

    public static Object findTemplateFromProvider(Object listener) {
        Object newTemplate = null;
        if (EventTemplateProvider.class.isAssignableFrom(listener.getClass())) {
            newTemplate = ((EventTemplateProvider)listener).getTemplate();
        } else {
            final AtomicReference ref = new AtomicReference();
            ReflectionUtils.doWithMethods((Class)AopUtils.getTargetClass((Object)listener), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (method.isAnnotationPresent(EventTemplate.class)) {
                        ref.set(method);
                    }
                }
            });
            if (ref.get() != null) {
                ((Method)ref.get()).setAccessible(true);
                try {
                    newTemplate = ((Method)ref.get()).invoke(listener, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to get template from method [" + ((Method)ref.get()).getName() + "]", e);
                }
            }
        }
        return newTemplate;
    }
}

