/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.events.support;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.openspaces.events.AbstractEventListenerContainer;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.beans.factory.DisposableBean;

public class EventContainersBus
implements DisposableBean,
ServiceDetailsProvider,
ServiceMonitorsProvider,
InternalDumpProcessor {
    public static final String SUFFIX = "_eventContainer";
    private ConcurrentHashMap<String, AbstractEventListenerContainer> containers = new ConcurrentHashMap();

    public void registerContainer(String name, AbstractEventListenerContainer container) {
        this.containers.put(name + SUFFIX, container);
    }

    public boolean unregisterContainer(String name) {
        AbstractEventListenerContainer container = this.containers.remove(name + SUFFIX);
        if (container != null) {
            container.destroy();
            return true;
        }
        return false;
    }

    public AbstractEventListenerContainer getEventContainer(String name) {
        return this.containers.get(name + SUFFIX);
    }

    public Collection<AbstractEventListenerContainer> getEventContainers() {
        return new ArrayList<AbstractEventListenerContainer>(this.containers.values());
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        ArrayList list = new ArrayList();
        for (AbstractEventListenerContainer container : this.containers.values()) {
            Collections.addAll(list, container.getServicesDetails());
        }
        return list.toArray(new ServiceDetails[list.size()]);
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        ArrayList list = new ArrayList();
        for (AbstractEventListenerContainer container : this.containers.values()) {
            Collections.addAll(list, container.getServicesMonitors());
        }
        return list.toArray(new ServiceMonitors[list.size()]);
    }

    public String getName() {
        return "event-container-bus";
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        for (AbstractEventListenerContainer container : this.containers.values()) {
            if (!(container instanceof InternalDumpProcessor)) continue;
            container.process(dump);
        }
    }

    public void destroy() throws Exception {
        for (AbstractEventListenerContainer container : this.containers.values()) {
            container.destroy();
        }
        this.containers.clear();
    }
}

