/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.extensions;

import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeOperationResult;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.query.IdQuery;
import com.gigaspaces.sync.change.IncrementOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.exception.DefaultExceptionTranslator;
import org.openspaces.core.exception.ExceptionTranslator;
import org.springframework.util.StringUtils;

public class ChangeExtension {
    private static final ExceptionTranslator exceptionTranslator = new DefaultExceptionTranslator();

    public static <T, D extends Number> D addAndGet(GigaSpace gigaSpace, IdQuery<T> idQuery, String path, D delta) {
        return ChangeExtension.addAndGet(gigaSpace, idQuery, path, delta, ChangeModifiers.NONE, 0L, TimeUnit.MILLISECONDS);
    }

    public static <T, D extends Number> D addAndGet(GigaSpace gigaSpace, IdQuery<T> idQuery, String path, D delta, long timeout, TimeUnit timeUnit) {
        return ChangeExtension.addAndGet(gigaSpace, idQuery, path, delta, ChangeModifiers.NONE, timeout, timeUnit);
    }

    public static <T, D extends Number> D addAndGet(GigaSpace gigaSpace, IdQuery<T> idQuery, String path, D delta, ChangeModifiers modifiers, long timeout, TimeUnit timeUnit) {
        if (idQuery == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        if (!StringUtils.hasLength((String)path)) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        ChangeResult<IdQuery<T>> changeResult = gigaSpace.change(idQuery, new ChangeSet().increment(path, delta), modifiers.add(ChangeModifiers.RETURN_DETAILED_RESULTS), timeUnit.toMillis(timeout));
        ChangedEntryDetails<IdQuery<T>> changedEntryDetails = ChangeExtension.getSingleChangedEntryDetails(changeResult);
        if (changedEntryDetails == null) {
            return null;
        }
        ChangeOperationResult changeOperationResult = (ChangeOperationResult)changedEntryDetails.getChangeOperationsResults().get(0);
        return (D)IncrementOperation.getNewValue((ChangeOperationResult)changeOperationResult);
    }

    private static <T> ChangedEntryDetails<T> getSingleChangedEntryDetails(ChangeResult<T> changeResult) {
        if (changeResult.getNumberOfChangedEntries() == 0) {
            return null;
        }
        if (changeResult.getNumberOfChangedEntries() != 1) {
            String message = "ambiguous result - change operation have modified more than one entry, this could point to having entry with the same id in multiple partitions and using an id query without a routing value";
            Collection changeEntries = changeResult.getResults();
            throw exceptionTranslator.translate((Throwable)new ChangeException(message, changeEntries, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST));
        }
        return (ChangedEntryDetails)changeResult.getResults().iterator().next();
    }

    public static <T> T getSingleChangeOperationResult(ChangeResult<?> changeResult) {
        ChangedEntryDetails<?> changedEntryDetails = ChangeExtension.getSingleChangedEntryDetails(changeResult);
        if (changedEntryDetails == null) {
            return null;
        }
        if (changedEntryDetails.getChangeOperationsResults().size() != 1) {
            String message = "ambiguous result - more than one changes were applied on the entry and as a result it contains more than one change operation result";
            Collection changeEntries = changeResult.getResults();
            throw exceptionTranslator.translate((Throwable)new ChangeException(message, changeEntries, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST));
        }
        return (T)((ChangeOperationResult)changedEntryDetails.getChangeOperationsResults().get(0)).getResult();
    }
}

