/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.launcher;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.internal.io.FileUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.service.SecurityResolver;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openspaces.launcher.WebLauncher;
import org.openspaces.launcher.WebLauncherConfig;
import org.openspaces.pu.container.support.CommandLineParser;

public class Launcher
implements Closeable {
    private final WebLauncherConfig config;
    private final WebLauncher webLauncher;
    private final Logger logger;

    public static void main(String[] args) throws Exception {
        List<String> helpArgs = Arrays.asList("help", "h");
        Properties props = Launcher.parseCommandLineArgs(args, helpArgs);
        for (String helpArg : helpArgs) {
            if (!props.containsKey(helpArg)) continue;
            Launcher.printHelpMessage();
            System.exit(0);
        }
        WebLauncherConfig config = new WebLauncherConfig(props);
        new Launcher(config);
    }

    public Launcher() {
        this(new WebLauncherConfig(new Properties()));
    }

    public Launcher(WebLauncherConfig config) {
        this.config = config;
        if (!Launcher.validateWar(config) || !Launcher.validateSslParameters(config)) {
            Launcher.printHelpMessage();
            System.exit(1);
        }
        Launcher.initIfNotDefined("org.openspaces.launcher.jetty.session.manager", null, "org.openspaces.pu.container.jee.jetty.GSSessionManager");
        Launcher.initIfNotDefined("com.gigaspaces.logger.RollingFileHandler.time-rolling-policy", null, "monthly");
        Launcher.initIfNotDefined("com.gigaspaces.webui.username.mandatory", "USER_NAME_MANDATORY", "false");
        if (!GSLogConfigLoader.isInitialized()) {
            GSLogConfigLoader.getLoader((String)config.getName());
            GSLogConfigLoader.getLoader();
        }
        this.logger = Logger.getLogger(config.getLoggerName());
        RuntimeInfo.logRuntimeInfo((Logger)this.logger, (String)("Starting " + config.getName() + ", security enabled:" + SecurityResolver.isSecurityEnabled() + ", host: " + config.getHostAddress() + ", port: " + config.getPort()));
        this.webLauncher = this.initWebLauncher();
        if (this.webLauncher == null) {
            System.exit(1);
        }
        this.launchBrowser();
    }

    @Override
    public void close() throws IOException {
        this.logger.info("Closing " + this.config.getName());
        if (this.webLauncher != null) {
            this.webLauncher.close();
        }
    }

    private WebLauncher initWebLauncher() {
        String webLauncherClass = System.getProperty("org.openspaces.launcher.class", "org.openspaces.launcher.JettyLauncher");
        try {
            WebLauncher webLauncher = (WebLauncher)ClassLoaderHelper.newInstance((String)webLauncherClass);
            webLauncher.launch(this.config);
            return webLauncher;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to start " + webLauncherClass, e);
            return null;
        }
    }

    private void launchBrowser() {
        String protocol = this.config.isSslEnabled() ? "https" : "http";
        String url = protocol + "://localhost:" + this.config.getPort();
        this.logger.info("Browsing to " + url);
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception e) {
            this.logger.warning("Failed to browse to XAP web-ui: " + e.getMessage());
        }
    }

    private static Properties parseCommandLineArgs(String[] args, Collection<String> helpArgs) {
        HashSet<String> parametersWithoutValues = new HashSet<String>();
        for (String helpArg : helpArgs) {
            parametersWithoutValues.add("-" + helpArg);
        }
        CommandLineParser.Parameter[] params = CommandLineParser.parse(args, parametersWithoutValues);
        Properties result = new Properties();
        for (CommandLineParser.Parameter param : params) {
            result.setProperty(param.getName(), param.getArguments()[0]);
        }
        return result;
    }

    private static void initIfNotDefined(String sysProp, String envVar, String defaultValue) {
        if (!System.getProperties().containsKey(sysProp)) {
            String value = envVar != null && System.getenv().containsKey(envVar) ? System.getenv(envVar) : defaultValue;
            System.setProperty(sysProp, value);
        }
    }

    private static void printHelpMessage() {
        System.out.println("Launcher -path <path> [-work <work>] [-port <port>] [-name <name>] [-logger <logger>] [-user-details-provider <provider>] [-user-details-properties <properties>] [-ssl.keyManagerPassword <key-manager-password>] [-ssl.keyStorePassword <key-store-password>] [-ssl.keyStorePath <key-store-path>] [-ssl.trustStorePath <trust-store-path>] [-ssl.trustStorePassword <trust-store-password>]");
    }

    private static boolean validateWar(WebLauncherConfig config) {
        if (!StringUtils.hasLength((String)config.getWarFilePath())) {
            return false;
        }
        File file = new File(config.getWarFilePath());
        if (!file.exists()) {
            System.out.println("Path does not exist: " + config.getWarFilePath());
            return false;
        }
        if (file.isFile()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] warFiles = FileUtils.findFiles((File)file, null, (String)".war");
            if (warFiles.length == 0) {
                System.out.println("Path does not contain any war files: " + config.getWarFilePath());
                return false;
            }
            if (warFiles.length > 1) {
                System.out.println("Found " + warFiles.length + " war files in " + config.getWarFilePath() + ", using " + warFiles[0].getPath());
            }
            config.setWarFilePath(warFiles[0].getPath());
            return true;
        }
        System.out.println("Path is neither file nor folder: " + config.getWarFilePath());
        return false;
    }

    private static boolean validateSslParameters(WebLauncherConfig config) {
        if (config.isSslEnabled()) {
            String sslKeyManagerPassword = config.getSslKeyManagerPassword();
            String sslKeyStorePassword = config.getSslKeyStorePassword();
            String sslKeyStorePath = config.getSslKeyStorePath();
            String sslTrustStorePath = config.getSslTrustStorePath();
            String sslTrustStorePassword = config.getSslTrustStorePassword();
            StringBuilder stringBuilder = new StringBuilder();
            if (sslKeyManagerPassword == null || sslKeyManagerPassword.trim().isEmpty()) {
                stringBuilder.append("ssl.keyManagerPassword");
                stringBuilder.append('\n');
            }
            if (sslKeyStorePassword == null || sslKeyStorePassword.trim().isEmpty()) {
                stringBuilder.append("ssl.keyStorePassword");
                stringBuilder.append('\n');
            }
            if (sslKeyStorePath == null || sslKeyStorePath.trim().isEmpty()) {
                stringBuilder.append("ssl.keyStorePath");
                stringBuilder.append('\n');
            }
            if (sslTrustStorePath == null || sslTrustStorePath.trim().isEmpty()) {
                stringBuilder.append("ssl.trustStorePath");
                stringBuilder.append('\n');
            }
            if (sslTrustStorePassword == null || sslTrustStorePassword.trim().isEmpty()) {
                stringBuilder.append("ssl.trustStorePassword");
                stringBuilder.append('\n');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, "Following ssl parameters or their values are missing:\n");
                System.out.println(stringBuilder.toString());
            }
            return stringBuilder.length() == 0;
        }
        return true;
    }
}

