/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.launcher;

import com.gigaspaces.start.SystemInfo;
import java.util.Properties;

public class WebLauncherConfig {
    private final String webuiHome = System.getProperty("com.gigaspaces.webui.path", SystemInfo.singleton().getXapHome() + "/tools/gs-webui");
    private final String name;
    private final String loggerName;
    private final int port;
    private final String hostAddress;
    private String warFilePath;
    private final String tempDirPath;
    private final String sslKeyStorePath;
    private final String sslKeyStorePassword;
    private final String sslKeyManagerPassword;
    private final String sslTrustStorePassword;
    private final String sslTrustStorePath;
    private final boolean sslEnabled;

    public WebLauncherConfig(Properties props) {
        this.name = props.getProperty("name", System.getProperty("org.openspaces.launcher.name", "GS Web UI"));
        this.loggerName = props.getProperty("logger", System.getProperty("org.openspaces.launcher.logger", "org.openspaces.launcher"));
        this.port = Integer.parseInt(props.getProperty("port", WebLauncherConfig.loadDefault("org.openspaces.launcher.port", "WEBUI_PORT", "8099")));
        this.hostAddress = props.getProperty("bind-address", WebLauncherConfig.loadDefault("org.openspaces.launcher.bind-address", "BIND_ADDRESS", "0.0.0.0"));
        this.warFilePath = props.getProperty("path", System.getProperty("org.openspaces.launcher.path", this.webuiHome));
        this.tempDirPath = props.getProperty("work", System.getProperty("org.openspaces.launcher.work", this.webuiHome + "/work"));
        this.sslKeyManagerPassword = props.getProperty("ssl.keyManagerPassword");
        this.sslKeyStorePassword = props.getProperty("ssl.keyStorePassword");
        this.sslKeyStorePath = props.getProperty("ssl.keyStorePath");
        this.sslTrustStorePath = props.getProperty("ssl.trustStorePath");
        this.sslTrustStorePassword = props.getProperty("ssl.trustStorePassword");
        boolean bl = this.sslEnabled = this.sslKeyManagerPassword != null || this.sslKeyStorePassword != null || this.sslKeyStorePath != null || this.sslTrustStorePath != null || this.sslTrustStorePassword != null;
        if (props.containsKey("user-details-provider")) {
            System.setProperty("user-details-provider", props.getProperty("user-details-provider"));
        }
        if (props.containsKey("user-details-properties")) {
            System.setProperty("user-details-properties", props.getProperty("user-details-properties"));
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getTempDirPath() {
        return this.tempDirPath;
    }

    public String getWarFilePath() {
        return this.warFilePath;
    }

    public void setWarFilePath(String warFilePath) {
        this.warFilePath = warFilePath;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslKeyManagerPassword() {
        return this.sslKeyManagerPassword;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStorePath() {
        return this.sslTrustStorePath;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    private static String loadDefault(String sysPropName, String envVarName, String defaultValue) {
        String result = System.getProperty(sysPropName);
        if (result == null) {
            result = System.getenv(envVarName);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }
}

