/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class Key
implements Externalizable {
    private static final long serialVersionUID = -1131139214094910487L;
    public byte[] bytes;
    private transient int hashCode;
    private static final ThreadLocal<StringBuilder> sbCache = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public Key() {
    }

    public Key(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Key key1 = (Key)o;
        return Arrays.equals(this.bytes, key1.bytes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = sbCache.get();
        sb.setLength(0);
        for (byte b : this.bytes) {
            sb.append(b);
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
        this.hashCode = Arrays.hashCode(this.bytes);
    }
}

