/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openspaces.memcached.Key;
import org.openspaces.memcached.util.BufferUtils;

public final class LocalCacheElement
implements Externalizable {
    private static final long serialVersionUID = -1132098185117104961L;
    private int expire;
    private int flags;
    private byte[] data;
    private Key key;
    private long casUnique = 0L;

    public LocalCacheElement() {
    }

    public LocalCacheElement(Key key) {
        this.key = key;
    }

    public LocalCacheElement(Key key, int flags, int expire, long casUnique) {
        this.key = key;
        this.flags = flags;
        this.expire = expire;
        this.casUnique = casUnique;
    }

    public static int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public int size() {
        return this.getData().length;
    }

    public LocalCacheElement append(LocalCacheElement element) {
        int newLength = this.getData().length + element.getData().length;
        LocalCacheElement replace = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        ByteBuffer b = ByteBuffer.allocateDirect(newLength);
        b.put(this.getData());
        b.put(element.getData());
        replace.setData(new byte[newLength]);
        b.flip();
        b.get(replace.getData());
        replace.setCasUnique(replace.getCasUnique() + 1L);
        return replace;
    }

    public LocalCacheElement prepend(LocalCacheElement element) {
        int newLength = this.getData().length + element.getData().length;
        LocalCacheElement replace = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        ByteBuffer b = ByteBuffer.allocateDirect(newLength);
        b.put(element.getData());
        b.put(this.getData());
        replace.setData(new byte[newLength]);
        b.flip();
        b.get(replace.getData());
        replace.setCasUnique(replace.getCasUnique() + 1L);
        return replace;
    }

    public IncrDecrResult add(int mod) {
        int old_val = BufferUtils.atoi(this.getData()) + mod;
        if (old_val < 0) {
            old_val = 0;
        }
        byte[] newData = BufferUtils.itoa(old_val);
        LocalCacheElement replace = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        replace.setData(newData);
        replace.setCasUnique(replace.getCasUnique() + 1L);
        return new IncrDecrResult(old_val, replace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCacheElement that = (LocalCacheElement)o;
        if (this.casUnique != that.casUnique) {
            return false;
        }
        if (this.expire != that.expire) {
            return false;
        }
        if (this.flags != that.flags) {
            return false;
        }
        if (!Arrays.equals(this.data, that.data)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.expire;
        result = 31 * result + this.flags;
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (int)(this.casUnique ^ this.casUnique >>> 32);
        return result;
    }

    public static LocalCacheElement key(Key key) {
        return new LocalCacheElement(key);
    }

    public int getExpire() {
        return this.expire;
    }

    public int getFlags() {
        return this.flags;
    }

    public byte[] getData() {
        return this.data;
    }

    public Key getKey() {
        return this.key;
    }

    public long getCasUnique() {
        return this.casUnique;
    }

    public void setCasUnique(long casUnique) {
        this.casUnique = casUnique;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.expire = in.readInt();
        this.flags = in.readInt();
        int length = in.readInt();
        this.data = new byte[length];
        for (int readSize = 0; readSize < length; readSize += in.read(this.data, readSize, length - readSize)) {
        }
        this.key = new Key(new byte[in.readInt()]);
        in.read(this.key.bytes);
        this.casUnique = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.expire);
        out.writeInt(this.flags);
        out.writeInt(this.data.length);
        out.write(this.data);
        out.write(this.key.bytes.length);
        out.write(this.key.bytes);
        out.writeLong(this.casUnique);
    }

    public static class IncrDecrResult {
        int oldValue;
        LocalCacheElement replace;

        public IncrDecrResult(int oldValue, LocalCacheElement replace) {
            this.oldValue = oldValue;
            this.replace = replace;
        }
    }
}

