/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.memcached.MemcachedServiceDetails;
import org.openspaces.memcached.MemcachedServiceMonitors;
import org.openspaces.memcached.SpaceCache;
import org.openspaces.memcached.protocol.UnifiedProtocolDecoder;
import org.openspaces.memcached.protocol.binary.MemcachedBinaryPipelineFactory;
import org.openspaces.memcached.protocol.text.MemcachedPipelineFactory;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MemCacheDaemon
implements InitializingBean,
DisposableBean,
BeanNameAware,
ServiceDetailsProvider,
ServiceMonitorsProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String memcachedVersion = "0.9";
    private GigaSpace space;
    private String beanName = "memcached";
    private String protocol = "dual";
    private String host;
    private int port;
    private int portRetries = 20;
    private boolean threaded = true;
    private int frameSize = 0x2000000;
    private int idleTime;
    private int boundedPort;
    private ServerSocketChannelFactory channelFactory;
    private DefaultChannelGroup allChannels;
    private SpaceCache cache;

    public void setSpace(GigaSpace space) {
        this.space = space;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPortRetries(int portRetries) {
        this.portRetries = portRetries;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void afterPropertiesSet() throws Exception {
        int i;
        this.cache = new SpaceCache(this.space);
        this.channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.allChannels = new DefaultChannelGroup("memcachedChannelGroup");
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.channelFactory);
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new UnifiedProtocolDecoder(MemCacheDaemon.this.cache, MemCacheDaemon.this.allChannels, MemCacheDaemon.memcachedVersion, MemCacheDaemon.this.idleTime, false, MemCacheDaemon.this.threaded)});
            }
        };
        if ("binary".equalsIgnoreCase(this.protocol)) {
            pipelineFactory = this.createMemcachedBinaryPipelineFactory(this.cache, memcachedVersion, false, this.idleTime, this.allChannels);
        } else if ("text".equalsIgnoreCase(this.protocol)) {
            pipelineFactory = this.createMemcachedPipelineFactory(this.cache, memcachedVersion, false, this.idleTime, this.frameSize, this.allChannels);
        }
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("sendBufferSize", (Object)65536);
        bootstrap.setOption("receiveBufferSize", (Object)65536);
        InetAddress address = null;
        if (this.host != null) {
            address = InetAddress.getByName(this.host);
        }
        Exception lastException = null;
        boolean success = false;
        for (i = 0; i < this.portRetries; ++i) {
            try {
                Channel serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(address, this.port + i));
                this.allChannels.add(serverChannel);
                success = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
                continue;
            }
        }
        if (!success) {
            throw lastException;
        }
        this.boundedPort = this.port + i;
        this.logger.info((Object)("memcached started on port [" + this.boundedPort + "]"));
    }

    protected ChannelPipelineFactory createMemcachedBinaryPipelineFactory(SpaceCache cache, String memcachedVersion, boolean verbose, int idleTime, DefaultChannelGroup allChannels) {
        return new MemcachedBinaryPipelineFactory(cache, memcachedVersion, verbose, idleTime, allChannels);
    }

    protected ChannelPipelineFactory createMemcachedPipelineFactory(SpaceCache cache, String memcachedVersion, boolean verbose, int idleTime, int receiveBufferSize, DefaultChannelGroup allChannels) {
        return new MemcachedPipelineFactory(cache, memcachedVersion, verbose, idleTime, receiveBufferSize, allChannels);
    }

    public void destroy() throws Exception {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            throw new RuntimeException("failure to complete closing all network channels");
        }
        try {
            this.cache.close();
        }
        catch (IOException e) {
            throw new RuntimeException("exception while closing storage", e);
        }
        this.channelFactory.releaseExternalResources();
        this.logger.info((Object)"memcached destroyed");
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{new MemcachedServiceDetails(this.beanName, this.space.getName(), this.boundedPort)};
    }

    @Override
    public ServiceMonitors[] getServicesMonitors() {
        return new ServiceMonitors[]{new MemcachedServiceMonitors(this.beanName, this.cache.getGetCmds(), this.cache.getSetCmds(), this.cache.getGetHits(), this.cache.getGetMisses())};
    }
}

