/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached;

import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.annotation.pojo.SpaceVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.memcached.Key;

@SpaceClass
public class MemcachedEntry
implements Externalizable {
    private static final long serialVersionUID = 7080552232191270155L;
    private Key key;
    private byte[] value;
    private int flags;
    private int version;

    public MemcachedEntry() {
    }

    public MemcachedEntry(Key key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    @SpaceId(autoGenerate=false)
    @SpaceRouting
    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @SpaceVersion
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.key == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.key.writeExternal(out);
        }
        if (this.value == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.value.length);
            out.write(this.value);
        }
        out.writeInt(this.flags);
        out.writeInt(this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.key = new Key();
            this.key.readExternal(in);
        }
        if (in.readBoolean()) {
            this.value = new byte[in.readInt()];
            in.readFully(this.value);
        }
        this.flags = in.readInt();
        this.version = in.readInt();
    }
}

