/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached;

import com.gigaspaces.client.ReadByIdsResult;
import com.gigaspaces.client.WriteModifiers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openspaces.core.EntryAlreadyInSpaceException;
import org.openspaces.core.EntryNotInSpaceException;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.SpaceOptimisticLockingFailureException;
import org.openspaces.memcached.Key;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.MemcachedEntry;
import org.openspaces.memcached.util.BufferUtils;

public class SpaceCache {
    public static final int THIRTY_DAYS = 2592000;
    private final GigaSpace space;
    protected final AtomicLong started = new AtomicLong();
    protected final AtomicLong getCmds = new AtomicLong();
    protected final AtomicLong setCmds = new AtomicLong();
    protected final AtomicLong getHits = new AtomicLong();
    protected final AtomicLong getMisses = new AtomicLong();

    public SpaceCache(GigaSpace space) {
        this.space = space;
        this.started.set(System.currentTimeMillis());
    }

    public DeleteResponse delete(Key key, int time) {
        if (time > 0) {
            MemcachedEntry entry = this.space.readById(MemcachedEntry.class, key);
            if (entry == null) {
                return DeleteResponse.NOT_FOUND;
            }
            this.space.write(entry, time);
            return DeleteResponse.DELETED;
        }
        MemcachedEntry entry = this.space.takeById(MemcachedEntry.class, key);
        return entry == null ? DeleteResponse.NOT_FOUND : DeleteResponse.DELETED;
    }

    public StoreResponse add(LocalCacheElement e) {
        try {
            MemcachedEntry entry = new MemcachedEntry(e.getKey(), e.getData());
            entry.setFlags(e.getFlags());
            this.space.write(entry, e.getExpire(), 0L, WriteModifiers.WRITE_ONLY);
            return StoreResponse.STORED;
        }
        catch (EntryAlreadyInSpaceException e1) {
            return StoreResponse.EXISTS;
        }
    }

    public StoreResponse replace(LocalCacheElement e) {
        try {
            MemcachedEntry entry = new MemcachedEntry(e.getKey(), e.getData());
            entry.setFlags(e.getFlags());
            this.space.write(entry, e.getExpire(), 0L, WriteModifiers.UPDATE_ONLY);
            return StoreResponse.STORED;
        }
        catch (EntryNotInSpaceException e1) {
            return StoreResponse.NOT_FOUND;
        }
    }

    public StoreResponse append(LocalCacheElement cacheElement) {
        while (true) {
            MemcachedEntry entry;
            if ((entry = this.space.readById(MemcachedEntry.class, cacheElement.getKey())) == null) {
                this.getMisses.incrementAndGet();
                return StoreResponse.NOT_FOUND;
            }
            byte[] newData = new byte[entry.getValue().length + cacheElement.getData().length];
            System.arraycopy(entry.getValue(), 0, newData, 0, entry.getValue().length);
            System.arraycopy(cacheElement.getData(), 0, newData, entry.getValue().length, cacheElement.getData().length);
            entry.setValue(newData);
            try {
                this.space.write(entry);
            }
            catch (SpaceOptimisticLockingFailureException e) {
                continue;
            }
            break;
        }
        return StoreResponse.STORED;
    }

    public StoreResponse prepend(LocalCacheElement cacheElement) {
        while (true) {
            MemcachedEntry entry;
            if ((entry = this.space.readById(MemcachedEntry.class, cacheElement.getKey())) == null) {
                this.getMisses.incrementAndGet();
                return StoreResponse.NOT_FOUND;
            }
            byte[] newData = new byte[entry.getValue().length + cacheElement.getData().length];
            System.arraycopy(cacheElement.getData(), 0, newData, 0, cacheElement.getData().length);
            System.arraycopy(entry.getValue(), 0, newData, cacheElement.getData().length, entry.getValue().length);
            entry.setValue(newData);
            try {
                this.space.write(entry);
            }
            catch (SpaceOptimisticLockingFailureException e) {
                continue;
            }
            break;
        }
        return StoreResponse.STORED;
    }

    public StoreResponse set(LocalCacheElement e) {
        this.setCmds.incrementAndGet();
        MemcachedEntry entry = new MemcachedEntry(e.getKey(), e.getData());
        entry.setFlags(e.getFlags());
        this.space.write(entry, e.getExpire());
        return StoreResponse.STORED;
    }

    public StoreResponse cas(Long cas_key, LocalCacheElement e) {
        try {
            MemcachedEntry entry = new MemcachedEntry(e.getKey(), e.getData());
            entry.setFlags(e.getFlags());
            entry.setVersion(cas_key.intValue());
            this.space.write(entry, e.getExpire(), 0L, WriteModifiers.UPDATE_ONLY);
            return StoreResponse.STORED;
        }
        catch (SpaceOptimisticLockingFailureException e1) {
            return StoreResponse.EXISTS;
        }
        catch (EntryNotInSpaceException e1) {
            this.getMisses.incrementAndGet();
            return StoreResponse.NOT_FOUND;
        }
    }

    public Integer get_add(Key key, int mod) {
        int val;
        while (true) {
            MemcachedEntry entry;
            if ((entry = this.space.readById(MemcachedEntry.class, key)) == null) {
                this.getMisses.incrementAndGet();
                return null;
            }
            val = BufferUtils.atoi(entry.getValue()) + mod;
            if (val < 0) {
                val = 0;
            }
            entry.setValue(BufferUtils.itoa(val));
            try {
                this.space.write(entry);
            }
            catch (SpaceOptimisticLockingFailureException e) {
                continue;
            }
            break;
        }
        return val;
    }

    public LocalCacheElement[] get(Key ... keys) {
        this.getCmds.incrementAndGet();
        try {
            if (keys.length == 1) {
                MemcachedEntry entry = this.space.readById(MemcachedEntry.class, keys[0]);
                if (entry == null) {
                    this.getMisses.incrementAndGet();
                    return new LocalCacheElement[]{null};
                }
                this.getHits.incrementAndGet();
                return new LocalCacheElement[]{this.convert(entry)};
            }
            int hits = 0;
            int misses = 0;
            LocalCacheElement[] retVal = new LocalCacheElement[keys.length];
            ReadByIdsResult<MemcachedEntry> result = this.space.readByIds(MemcachedEntry.class, keys);
            for (int i = 0; i < ((MemcachedEntry[])result.getResultsArray()).length; ++i) {
                MemcachedEntry entry = ((MemcachedEntry[])result.getResultsArray())[i];
                if (entry == null) {
                    ++misses;
                    retVal[i] = null;
                    continue;
                }
                ++hits;
                retVal[i] = this.convert(entry);
            }
            this.getMisses.addAndGet(misses);
            this.getHits.addAndGet(hits);
            return retVal;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean flush_all() {
        return false;
    }

    public boolean flush_all(int expire) {
        return false;
    }

    public void close() throws IOException {
    }

    public long getCurrentItems() {
        return this.space.count(new MemcachedEntry());
    }

    public long getLimitMaxBytes() {
        return -1L;
    }

    public long getCurrentBytes() {
        return -1L;
    }

    public long getGetCmds() {
        return this.getCmds.get();
    }

    public long getSetCmds() {
        return this.setCmds.get();
    }

    public long getGetHits() {
        return this.getHits.get();
    }

    public long getGetMisses() {
        return this.getMisses.get();
    }

    public Map<String, Set<String>> stat(String arg) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        this.multiSet(result, "version", "0.9");
        this.multiSet(result, "cmd_gets", String.valueOf(this.getGetCmds()));
        this.multiSet(result, "cmd_sets", String.valueOf(this.getSetCmds()));
        this.multiSet(result, "get_hits", String.valueOf(this.getGetHits()));
        this.multiSet(result, "get_misses", String.valueOf(this.getGetMisses()));
        this.multiSet(result, "time", String.valueOf(String.valueOf(System.currentTimeMillis())));
        this.multiSet(result, "uptime", String.valueOf(System.currentTimeMillis() - this.started.longValue()));
        this.multiSet(result, "cur_items", String.valueOf(this.getCurrentItems()));
        this.multiSet(result, "limit_maxbytes", String.valueOf(this.getLimitMaxBytes()));
        this.multiSet(result, "current_bytes", String.valueOf(this.getCurrentBytes()));
        this.multiSet(result, "free_bytes", String.valueOf(Runtime.getRuntime().freeMemory()));
        this.multiSet(result, "pid", String.valueOf(Thread.currentThread().getId()));
        this.multiSet(result, "rusage_user", "0:0");
        this.multiSet(result, "rusage_system", "0:0");
        this.multiSet(result, "connection_structures", "0");
        this.multiSet(result, "bytes_read", "0");
        this.multiSet(result, "bytes_written", "0");
        return result;
    }

    private void multiSet(Map<String, Set<String>> map, String key, String val) {
        Set<String> cur = map.get(key);
        if (cur == null) {
            cur = new HashSet<String>();
        }
        cur.add(val);
        map.put(key, cur);
    }

    public void asyncEventPing() {
    }

    private LocalCacheElement convert(MemcachedEntry entry) throws UnsupportedEncodingException {
        LocalCacheElement element = new LocalCacheElement(entry.getKey(), entry.getFlags(), -1, entry.getVersion());
        element.setData(entry.getValue());
        return element;
    }

    public static enum DeleteResponse {
        DELETED,
        NOT_FOUND;

    }

    public static enum StoreResponse {
        STORED,
        NOT_STORED,
        EXISTS,
        NOT_FOUND;

    }
}

