/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspaces.memcached.Key;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.protocol.Op;

public final class CommandMessage
implements Serializable {
    private static final long serialVersionUID = 1663628151791997691L;
    public final Op op;
    public LocalCacheElement element;
    public List<Key> keys;
    public boolean noreply;
    public long cas_key;
    public int time = 0;
    public ErrorType error = ErrorType.OK;
    public String errorString;
    public int opaque;
    public boolean addKeyToResponse = false;
    public Integer incrDefault;
    public int incrExpiry;
    public int incrAmount;

    private CommandMessage(Op op) {
        this.op = op;
        this.element = null;
        this.keys = new ArrayList<Key>();
    }

    public void setKey(byte[] key) {
        this.keys = new ArrayList<Key>();
        this.keys.add(new Key(key));
    }

    public void setKeys(Iterable<byte[]> keys) {
        this.keys = new ArrayList<Key>();
        for (byte[] key : keys) {
            this.keys.add(new Key(key));
        }
    }

    public static CommandMessage error(String errorString) {
        CommandMessage errcmd = new CommandMessage(null);
        errcmd.error = ErrorType.ERROR;
        errcmd.errorString = errorString;
        return errcmd;
    }

    public static CommandMessage clientError(String errorString) {
        CommandMessage errcmd = new CommandMessage(null);
        errcmd.error = ErrorType.CLIENT_ERROR;
        errcmd.errorString = errorString;
        return errcmd;
    }

    public static CommandMessage command(Op operation) {
        return new CommandMessage(operation);
    }

    public static enum ErrorType {
        OK,
        ERROR,
        CLIENT_ERROR;

    }
}

