/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.memcached.protocol;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.openspaces.memcached.Key;
import org.openspaces.memcached.LocalCacheElement;
import org.openspaces.memcached.SpaceCache;
import org.openspaces.memcached.protocol.CommandMessage;
import org.openspaces.memcached.protocol.Op;
import org.openspaces.memcached.protocol.ResponseMessage;
import org.openspaces.memcached.protocol.exceptions.UnknownCommandException;

@ChannelHandler.Sharable
public final class MemcachedCommandHandler
extends SimpleChannelUpstreamHandler {
    protected static final Log logger = LogFactory.getLog(MemcachedCommandHandler.class);
    public final AtomicInteger curr_conns = new AtomicInteger();
    public final AtomicInteger total_conns = new AtomicInteger();
    public final String version;
    public final int idle_limit;
    public final boolean verbose;
    private final SpaceCache cache;
    private final DefaultChannelGroup channelGroup;

    public MemcachedCommandHandler(SpaceCache cache, String memcachedVersion, boolean verbosity, int idle, DefaultChannelGroup channelGroup) {
        this.cache = cache;
        this.version = memcachedVersion;
        this.verbose = verbosity;
        this.idle_limit = idle;
        this.channelGroup = channelGroup;
    }

    public void channelOpen(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.total_conns.incrementAndGet();
        this.curr_conns.incrementAndGet();
        this.channelGroup.add(channelHandlerContext.getChannel());
    }

    public void channelClosed(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.curr_conns.decrementAndGet();
        this.channelGroup.remove((Object)channelHandlerContext.getChannel());
    }

    public void messageReceived(ChannelHandlerContext channelHandlerContext, MessageEvent messageEvent) throws Exception {
        if (!(messageEvent.getMessage() instanceof CommandMessage)) {
            channelHandlerContext.sendUpstream((ChannelEvent)messageEvent);
            return;
        }
        CommandMessage command = (CommandMessage)messageEvent.getMessage();
        Op cmd = command.op;
        int cmdKeysSize = command.keys.size();
        this.cache.asyncEventPing();
        if (this.verbose) {
            StringBuilder log = new StringBuilder();
            log.append((Object)cmd);
            if (command.element != null) {
                log.append(" ").append(command.element.getKey());
            }
            for (int i = 0; i < cmdKeysSize; ++i) {
                log.append(" ").append(command.keys.get(i));
            }
            logger.info((Object)log.toString());
        }
        Channel channel = messageEvent.getChannel();
        if (cmd == Op.GET || cmd == Op.GETS) {
            this.handleGets(channelHandlerContext, command, channel);
        } else if (cmd == Op.SET) {
            this.handleSet(channelHandlerContext, command, channel);
        } else if (cmd == Op.CAS) {
            this.handleCas(channelHandlerContext, command, channel);
        } else if (cmd == Op.ADD) {
            this.handleAdd(channelHandlerContext, command, channel);
        } else if (cmd == Op.REPLACE) {
            this.handleReplace(channelHandlerContext, command, channel);
        } else if (cmd == Op.APPEND) {
            this.handleAppend(channelHandlerContext, command, channel);
        } else if (cmd == Op.PREPEND) {
            this.handlePrepend(channelHandlerContext, command, channel);
        } else if (cmd == Op.INCR) {
            this.handleIncr(channelHandlerContext, command, channel);
        } else if (cmd == Op.DECR) {
            this.handleDecr(channelHandlerContext, command, channel);
        } else if (cmd == Op.DELETE) {
            this.handleDelete(channelHandlerContext, command, channel);
        } else if (cmd == Op.STATS) {
            this.handleStats(channelHandlerContext, command, cmdKeysSize, channel);
        } else if (cmd == Op.VERSION) {
            this.handleVersion(channelHandlerContext, command, channel);
        } else if (cmd == Op.QUIT) {
            this.handleQuit(channel);
        } else if (cmd == Op.FLUSH_ALL) {
            this.handleFlush(channelHandlerContext, command, channel);
        } else if (cmd == Op.VERBOSITY) {
            this.handleVerbosity(channelHandlerContext, command, channel);
        } else if (cmd == null) {
            this.handleNoOp(channelHandlerContext, command);
        } else {
            throw new UnknownCommandException("unknown command:" + (Object)((Object)cmd));
        }
    }

    protected void handleNoOp(ChannelHandlerContext channelHandlerContext, CommandMessage command) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command));
    }

    protected void handleFlush(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withFlushResponse(this.cache.flush_all(command.time)), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleVerbosity(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleQuit(Channel channel) {
        channel.disconnect();
    }

    protected void handleVersion(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        ResponseMessage responseMessage = new ResponseMessage(command);
        responseMessage.version = this.version;
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)responseMessage, (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleStats(ChannelHandlerContext channelHandlerContext, CommandMessage command, int cmdKeysSize, Channel channel) {
        String option = "";
        if (cmdKeysSize > 0) {
            option = new String(command.keys.get((int)0).bytes);
        }
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withStatResponse(this.cache.stat(option)), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleDelete(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.DeleteResponse dr = this.cache.delete(command.keys.get(0), command.time);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withDeleteResponse(dr), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleDecr(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Integer incrDecrResp = this.cache.get_add(command.keys.get(0), -1 * command.incrAmount);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withIncrDecrResponse(incrDecrResp), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleIncr(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Integer incrDecrResp = this.cache.get_add(command.keys.get(0), command.incrAmount);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withIncrDecrResponse(incrDecrResp), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handlePrepend(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.prepend(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleAppend(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.append(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleReplace(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.replace(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleAdd(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.add(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleCas(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.cas(command.cas_key, command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleSet(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        SpaceCache.StoreResponse ret = this.cache.set(command.element);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)new ResponseMessage(command).withResponse(ret), (SocketAddress)channel.getRemoteAddress());
    }

    protected void handleGets(ChannelHandlerContext channelHandlerContext, CommandMessage command, Channel channel) {
        Key[] keys = new Key[command.keys.size()];
        keys = command.keys.toArray(keys);
        LocalCacheElement[] results = this.get(keys);
        ResponseMessage resp = new ResponseMessage(command).withElements(results);
        Channels.fireMessageReceived((ChannelHandlerContext)channelHandlerContext, (Object)resp, (SocketAddress)channel.getRemoteAddress());
    }

    private LocalCacheElement[] get(Key ... keys) {
        return this.cache.get(keys);
    }
}

